/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.wizards.buildpath.newsourcepage;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.buildpath.BuildpathModifier;
import org.eclipse.dltk.internal.ui.scriptview.BuildPathContainer;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElement;
import org.eclipse.dltk.internal.ui.wizards.buildpath.newsourcepage.RemoveLinkedFolderDialog;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;

public class RemoveFromBuildpathAction
extends Action
implements ISelectionChangedListener {
    private final IWorkbenchSite fSite;
    private List fSelectedElements;

    public RemoveFromBuildpathAction(IWorkbenchSite site) {
        super(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_RemoveFromCP_label, DLTKPluginImages.DESC_ELCL_REMOVE_FROM_BP);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_RemoveFromCP_tooltip);
        this.fSite = site;
        this.fSelectedElements = new ArrayList();
    }

    public void run() {
        try {
            IScriptProject project;
            Object object = this.fSelectedElements.get(0);
            if (object instanceof IScriptProject) {
                project = (IScriptProject)object;
            } else if (object instanceof IProjectFragment) {
                IProjectFragment root = (IProjectFragment)object;
                project = root.getScriptProject();
            } else {
                BuildPathContainer container = (BuildPathContainer)object;
                project = container.getScriptProject();
            }
            ArrayList elementsToRemove = new ArrayList();
            ArrayList foldersToDelete = new ArrayList();
            this.queryToRemoveLinkedFolders(elementsToRemove, foldersToDelete);
            IRunnableWithProgress runnable = monitor -> {
                try {
                    try {
                        monitor.beginTask(NewWizardMessages.BuildpathModifier_Monitor_RemoveFromBuildpath, elementsToRemove.size() + foldersToDelete.size());
                        List result = this.removeFromBuildpath(elementsToRemove, project, (IProgressMonitor)new SubProgressMonitor(monitor, elementsToRemove.size()));
                        result.removeAll(foldersToDelete);
                        this.deleteFolders(foldersToDelete, (IProgressMonitor)new SubProgressMonitor(monitor, foldersToDelete.size()));
                        if (result.size() == 0) {
                            result.add(project);
                        }
                        this.selectAndReveal((ISelection)new StructuredSelection(result));
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            };
            PlatformUI.getWorkbench().getProgressService().run(true, false, runnable);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                this.showExceptionDialog((CoreException)e.getCause());
            } else {
                DLTKUIPlugin.log(e);
            }
        }
        catch (InterruptedException e) {
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
    }

    private void deleteFolders(List folders, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(NewWizardMessages.BuildpathModifier_Monitor_RemoveFromBuildpath, folders.size());
            for (IFolder folder : folders) {
                folder.delete(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        finally {
            monitor.done();
        }
    }

    private List removeFromBuildpath(List elements, IScriptProject project, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(NewWizardMessages.BuildpathModifier_Monitor_RemoveFromBuildpath, elements.size() + 1);
            List<BPListElement> existingEntries = BuildpathModifier.getExistingEntries(project);
            ArrayList<IScriptProject> result = new ArrayList<IScriptProject>();
            int i = 0;
            while (i < elements.size()) {
                IScriptProject res;
                Object element = elements.get(i);
                if (element instanceof IScriptProject) {
                    res = BuildpathModifier.removeFromBuildpath((IScriptProject)element, existingEntries, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    result.add(res);
                } else if (element instanceof IProjectFragment) {
                    res = BuildpathModifier.removeFromBuildpath((IProjectFragment)element, existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    if (res != null) {
                        result.add(res);
                    }
                } else {
                    existingEntries.remove(BPListElement.createFromExisting(((BuildPathContainer)element).getBuildpathEntry(), project));
                }
                ++i;
            }
            BuildpathModifier.commitBuildPath(existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ArrayList<IScriptProject> arrayList = result;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    private void queryToRemoveLinkedFolders(List elementsToRemove, List foldersToDelete) throws ModelException {
        Shell shell = this.fSite.getShell() != null ? this.fSite.getShell() : DLTKUIPlugin.getActiveWorkbenchShell();
        for (Object element : this.fSelectedElements) {
            if (element instanceof IProjectFragment) {
                IFolder folder = this.getLinkedSourceFolder((IProjectFragment)element);
                if (folder != null) {
                    int result;
                    RemoveLinkedFolderDialog dialog = new RemoveLinkedFolderDialog(shell, folder);
                    int n = result = dialog.open() == 0 ? dialog.getRemoveStatus() : 0;
                    if (result == 0) continue;
                    if (result == 1) {
                        elementsToRemove.add(element);
                        continue;
                    }
                    if (result != 2) continue;
                    elementsToRemove.add(element);
                    foldersToDelete.add(folder);
                    continue;
                }
                elementsToRemove.add(element);
                continue;
            }
            elementsToRemove.add(element);
        }
    }

    private IFolder getLinkedSourceFolder(IProjectFragment root) throws ModelException {
        if (root.getKind() != 1) {
            return null;
        }
        IResource resource = root.getCorrespondingResource();
        if (!(resource instanceof IFolder)) {
            return null;
        }
        IFolder folder = (IFolder)resource;
        if (!folder.isLinked()) {
            return null;
        }
        return folder;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            this.setEnabled(this.canHandle((IStructuredSelection)selection));
        } else {
            this.setEnabled(this.canHandle((IStructuredSelection)StructuredSelection.EMPTY));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean canHandle(IStructuredSelection elements) {
        if (elements.size() == 0) {
            return false;
        }
        try {
            IBuildpathEntry entry;
            IScriptProject project;
            Object element;
            this.fSelectedElements.clear();
            Iterator iter = elements.iterator();
            do {
                if (!iter.hasNext()) {
                    return true;
                }
                element = iter.next();
                this.fSelectedElements.add(element);
                if (element instanceof IProjectFragment || element instanceof IScriptProject || element instanceof BuildPathContainer) continue;
                return false;
            } while (!(element instanceof IScriptProject ? !BuildpathModifier.isSourceFolder(project = (IScriptProject)element) : element instanceof IProjectFragment && (entry = ((IProjectFragment)element).getRawBuildpathEntry()) != null && entry.getEntryKind() == 5));
            return false;
        }
        catch (ModelException modelException) {
            return false;
        }
    }

    private void showExceptionDialog(CoreException exception) {
        this.showError(exception, this.fSite.getShell(), NewWizardMessages.RemoveFromBuildpathAction_ErrorTitle, exception.getMessage());
    }

    private void showError(CoreException e, Shell shell, String title, String message) {
        IStatus status = e.getStatus();
        if (status != null) {
            ErrorDialog.openError((Shell)shell, (String)message, (String)title, (IStatus)status);
        } else {
            MessageDialog.openError((Shell)shell, (String)title, (String)message);
        }
    }

    private void selectAndReveal(ISelection selection) {
        IWorkbenchPage page = this.fSite.getPage();
        if (page == null) {
            return;
        }
        ArrayList<IWorkbenchPart> parts = new ArrayList<IWorkbenchPart>();
        IViewReference[] refs = page.getViewReferences();
        int i = 0;
        while (i < refs.length) {
            IWorkbenchPart part = refs[i].getPart(false);
            if (part != null) {
                parts.add(part);
            }
            ++i;
        }
        refs = page.getEditorReferences();
        i = 0;
        while (i < refs.length) {
            if (refs[i].getPart(false) != null) {
                parts.add(refs[i].getPart(false));
            }
            ++i;
        }
        for (IWorkbenchPart part : parts) {
            ISetSelectionTarget target = null;
            target = part instanceof ISetSelectionTarget ? (ISetSelectionTarget)part : (ISetSelectionTarget)part.getAdapter(ISetSelectionTarget.class);
            if (target == null) continue;
            ISetSelectionTarget finalTarget = target;
            page.getWorkbenchWindow().getShell().getDisplay().asyncExec(() -> finalTarget.selectReveal(selection));
        }
    }
}

