/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.msft.internal.sqlserver.loaders;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCSchemaLoader;
import org.eclipse.datatools.enablement.msft.internal.sqlserver.models.SqlServerSchema;
import org.eclipse.datatools.modelbase.sql.schema.Schema;

public class SQL2005SchemaLoader
extends JDBCSchemaLoader {
    private static final String SCHEMA_QUERY = "select CATALOG_NAME as 'TABLE_CATALOG', SCHEMA_NAME as 'TABLE_SCHEM' from catalogName.INFORMATION_SCHEMA.SCHEMATA";

    private static final String getSchemaQuery(String catalogName) {
        return SCHEMA_QUERY.replaceAll("catalogName", catalogName);
    }

    public SQL2005SchemaLoader() {
        super(null);
    }

    public SQL2005SchemaLoader(ICatalogObject catalogObject) {
        super(catalogObject);
    }

    protected Schema createSchema() {
        return new SqlServerSchema();
    }

    protected ResultSet createResultSet() throws SQLException {
        try {
            return super.createResultSet();
        }
        catch (Exception exception) {
            String query = SQL2005SchemaLoader.getSchemaQuery(this.getCatalog().getName());
            if (this.getJDBCFilterPattern() != null && this.getJDBCFilterPattern().length() > 0) {
                String filter = " AND ALIAS LIKE " + this.getJDBCFilterPattern();
                query = String.valueOf(query) + filter;
            }
            query = String.valueOf(query) + " ORDER BY " + "TABLE_SCHEM";
            return this.getCatalogObject().getConnection().createStatement().executeQuery(query);
        }
    }

    protected boolean isSchemaInCatalog(ResultSet rs) throws SQLException {
        if (super.isSchemaInCatalog(rs)) {
            return true;
        }
        String catalogName = rs.getString("TABLE_CATALOG");
        if (catalogName == null) {
            return false;
        }
        if (catalogName.equals("dbo")) {
            return this.isCurrentCatalog();
        }
        return false;
    }
}

