/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.workspace;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.eclipse.buildship.core.internal.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.internal.util.gradle.GradleVersion;
import org.eclipse.buildship.core.internal.util.gradle.IdeFriendlyClassLoading;
import org.eclipse.buildship.core.internal.util.gradle.SimpleIntermediateResultHandler;
import org.eclipse.buildship.core.internal.workspace.FetchStrategy;
import org.eclipse.buildship.core.internal.workspace.InternalGradleBuild;
import org.eclipse.buildship.core.internal.workspace.ModelProvider;
import org.eclipse.buildship.core.internal.workspace.TellGradleToRunSynchronizationTasks;
import org.eclipse.core.runtime.IProgressMonitor;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.eclipse.EclipseProject;

public final class DefaultModelProvider
implements ModelProvider {
    private final InternalGradleBuild gradleBuild;
    private final Cache<Object, Object> cache = CacheBuilder.newBuilder().build();

    public DefaultModelProvider(InternalGradleBuild gradleBuild) {
        this.gradleBuild = gradleBuild;
    }

    @Override
    public <T> T fetchModel(Class<T> model, FetchStrategy strategy, CancellationTokenSource tokenSource, IProgressMonitor monitor) {
        return (T)this.executeOperation(() -> this.gradleBuild.withConnection(connection -> DefaultModelProvider.queryModel(model, connection), tokenSource, monitor), strategy, model);
    }

    @Override
    public <T> Collection<T> fetchModels(Class<T> model, FetchStrategy strategy, CancellationTokenSource tokenSource, IProgressMonitor monitor) {
        return this.executeOperation(() -> this.gradleBuild.withConnection(connection -> {
            BuildEnvironment buildEnvironment = (BuildEnvironment)connection.getModel(BuildEnvironment.class);
            GradleVersion gradleVersion = GradleVersion.version(buildEnvironment.getGradle().getGradleVersion());
            if (DefaultModelProvider.supportsCompositeBuilds(gradleVersion)) {
                return DefaultModelProvider.queryCompositeModel(model, connection);
            }
            return ImmutableList.of(DefaultModelProvider.queryModel(model, connection));
        }, tokenSource, monitor), strategy, model);
    }

    @Override
    public Collection<EclipseProject> fetchEclipseProjectAndRunSyncTasks(CancellationTokenSource tokenSource, IProgressMonitor monitor) {
        return this.executeOperation(() -> this.gradleBuild.withConnection(connection -> {
            BuildEnvironment buildEnvironment = (BuildEnvironment)connection.getModel(BuildEnvironment.class);
            GradleVersion gradleVersion = GradleVersion.version(buildEnvironment.getGradle().getGradleVersion());
            if (DefaultModelProvider.supportsSyncTasksInEclipsePluginConfig(gradleVersion)) {
                return DefaultModelProvider.runTasksAndQueryCompositeEclipseModel(connection);
            }
            if (DefaultModelProvider.supportsCompositeBuilds(gradleVersion)) {
                return DefaultModelProvider.queryCompositeModel(EclipseProject.class, connection);
            }
            return ImmutableList.of((Object)DefaultModelProvider.queryModel(EclipseProject.class, connection));
        }, tokenSource, monitor), FetchStrategy.FORCE_RELOAD, EclipseProject.class);
    }

    private <T> T executeOperation(Callable<T> operation, FetchStrategy fetchStrategy, Class<?> cacheKey) {
        if (FetchStrategy.FROM_CACHE_ONLY == fetchStrategy) {
            Object result = this.cache.getIfPresent(cacheKey);
            return (T)result;
        }
        if (FetchStrategy.FORCE_RELOAD == fetchStrategy) {
            this.cache.invalidate(cacheKey);
        }
        T value = this.getFromCache(cacheKey, operation);
        return value;
    }

    private <U> U getFromCache(Class<?> cacheKey, Callable<U> cacheValueLoader) {
        try {
            Object result = this.cache.get(cacheKey, cacheValueLoader);
            return (U)result;
        }
        catch (Exception e) {
            if (e instanceof UncheckedExecutionException && e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new GradlePluginsRuntimeException(e);
        }
    }

    private static boolean supportsSyncTasksInEclipsePluginConfig(GradleVersion gradleVersion) {
        return gradleVersion.getBaseVersion().compareTo(GradleVersion.version("5.4")) >= 0;
    }

    private static boolean supportsCompositeBuilds(GradleVersion gradleVersion) {
        return gradleVersion.getBaseVersion().compareTo(GradleVersion.version("3.3")) >= 0;
    }

    private static Collection<EclipseProject> runTasksAndQueryCompositeEclipseModel(ProjectConnection connection) {
        BuildAction<Collection<EclipseProject>> query = IdeFriendlyClassLoading.loadCompositeModelQuery(EclipseProject.class);
        SimpleIntermediateResultHandler resultHandler = new SimpleIntermediateResultHandler();
        connection.action().projectsLoaded((BuildAction)IdeFriendlyClassLoading.loadClass(TellGradleToRunSynchronizationTasks.class), new SimpleIntermediateResultHandler()).buildFinished(query, resultHandler).build().forTasks(new String[0]).run();
        return (Collection)resultHandler.getValue();
    }

    private static <T> Collection<T> queryCompositeModel(Class<T> model, ProjectConnection connection) {
        BuildAction<Collection<T>> query = IdeFriendlyClassLoading.loadCompositeModelQuery(model);
        return (Collection)connection.action(query).run();
    }

    private static <T> T queryModel(Class<T> model, ProjectConnection connection) {
        return (T)connection.getModel(model);
    }
}

