/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core.index;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.internal.qt.core.QtMethodUtil;
import org.eclipse.cdt.internal.qt.core.index.IQMethod;
import org.eclipse.cdt.internal.qt.core.index.IQObject;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMQMethod;
import org.eclipse.core.runtime.CoreException;

public class QMethod
implements IQMethod {
    private final IQObject owner;
    private final String name;
    private final IQMethod.Kind kind;
    private final Collection<String> signatures;
    private final Long revision;

    public QMethod(IQObject owner, QtPDOMQMethod pdom) throws CoreException {
        this.owner = owner;
        this.name = pdom.getName();
        this.kind = pdom.getKind();
        this.signatures = QtMethodUtil.getDecodedQtMethodSignatures(pdom.getQtEncodedSignatures());
        this.revision = pdom.getRevision();
    }

    @Override
    public boolean isOverride(IQObject.IMember member) {
        if (!IQMethod.class.isAssignableFrom(member.getClass())) {
            return false;
        }
        IQMethod other = (IQMethod)member;
        if (this.name == null ? other.getName() != null : !this.name.equals(other.getName())) {
            return false;
        }
        IBinding otherBinding = other.getBinding();
        if (otherBinding == null) {
            return this.getBinding() == null;
        }
        return false;
    }

    @Override
    public IBinding getBinding() {
        return null;
    }

    @Override
    public IQObject getOwner() {
        return this.owner;
    }

    @Override
    public IQMethod.Kind getKind() {
        return this.kind;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<String> getSignatures() {
        return this.signatures == null ? Collections.emptyList() : this.signatures;
    }

    @Override
    public Long getRevision() {
        return this.revision;
    }

    public String toString() {
        return String.valueOf(this.kind.toString()) + ' ' + this.signatures;
    }
}

