/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mockdata.generator;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mockdata.generator.AbstractMockValueGenerator;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;

public class ConstantGenerator
extends AbstractMockValueGenerator {
    private static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd-MM-yyyy");
    private Object value;

    @Override
    public void init(DBSDataManipulator container, DBSAttributeBase attribute, Map<Object, Object> properties) throws DBException {
        super.init(container, attribute, properties);
        Object value = properties.get("value");
        if (value != null) {
            if (attribute.getDataKind() == DBPDataKind.DATETIME) {
                try {
                    this.value = DATE_FORMAT.parse((String)value);
                }
                catch (ParseException e) {
                    throw new DBException("Can't parse the value '" + value + "' as a date", (Throwable)e);
                }
            } else {
                this.value = value;
            }
        } else if (attribute.getDataKind() == DBPDataKind.STRING) {
            this.value = "";
        }
    }

    @Override
    public Object generateOneValue(DBRProgressMonitor monitor) throws DBException, IOException {
        if (this.isGenerateNULL()) {
            return null;
        }
        return this.value;
    }
}

