/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Spinner;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPTransactionIsolation;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionBootstrap;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPConnectionType;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IDataSourceConnectionTester;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionWizard;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionWizardPage;
import org.jkiss.dbeaver.ui.dialogs.connection.EditBootstrapQueriesDialog;
import org.jkiss.utils.CommonUtils;

class ConnectionPageInitialization
extends ConnectionWizardPage
implements IDataSourceConnectionTester {
    static final String PAGE_NAME = ConnectionPageInitialization.class.getSimpleName();
    private static final Log log = Log.getLog(ConnectionPageInitialization.class);
    private DataSourceDescriptor dataSourceDescriptor;
    private Button autocommit;
    private Combo isolationLevel;
    private Combo defaultSchema;
    private Spinner keepAliveInterval;
    private Font boldFont;
    private boolean activated = false;
    private List<DBPTransactionIsolation> supportedLevels = new ArrayList<DBPTransactionIsolation>();
    private List<String> bootstrapQueries;
    private boolean ignoreBootstrapErrors;
    private boolean txnOptionsLoaded = false;

    private ConnectionPageInitialization() {
        super(PAGE_NAME);
        this.setTitle(CoreMessages.dialog_connection_wizard_connection_init);
        this.setDescription(CoreMessages.dialog_connection_wizard_connection_init_description);
        this.bootstrapQueries = new ArrayList<String>();
    }

    ConnectionPageInitialization(DataSourceDescriptor dataSourceDescriptor) {
        this();
        this.dataSourceDescriptor = dataSourceDescriptor;
        this.bootstrapQueries = new ArrayList<String>(dataSourceDescriptor.getConnectionConfiguration().getBootstrap().getInitQueries());
        this.ignoreBootstrapErrors = dataSourceDescriptor.getConnectionConfiguration().getBootstrap().isIgnoreErrors();
    }

    public void dispose() {
        UIUtils.dispose((Resource)this.boldFont);
        super.dispose();
    }

    public void activatePage() {
        if (this.dataSourceDescriptor != null) {
            if (!this.activated) {
                DBPConnectionConfiguration conConfig = this.dataSourceDescriptor.getConnectionConfiguration();
                this.autocommit.setSelection(this.dataSourceDescriptor.isDefaultAutoCommit());
                this.isolationLevel.add("");
                DataSourceDescriptor originalDataSource = ((ConnectionWizard)this.getWizard()).getOriginalDataSource();
                if (originalDataSource != null && originalDataSource.isConnected()) {
                    DBPDataSource dataSource = originalDataSource.getDataSource();
                    this.loadDatabaseSettings(dataSource);
                }
                this.defaultSchema.setText(CommonUtils.notEmpty((String)conConfig.getBootstrap().getDefaultObjectName()));
                this.keepAliveInterval.setSelection(conConfig.getKeepAliveInterval());
                this.activated = true;
            }
        } else {
            this.isolationLevel.setEnabled(false);
            this.defaultSchema.setText("");
        }
    }

    private void loadDatabaseSettings(DBPDataSource dataSource) {
        try {
            this.getContainer().run(true, true, monitor -> this.loadDatabaseSettings((DBRProgressMonitor)new DefaultProgressMonitor(monitor), dataSource));
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Database info reading", "Error reading information from database", e.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
    }

    private void loadDatabaseSettings(DBRProgressMonitor monitor, DBPDataSource dataSource) throws InvocationTargetException, InterruptedException {
        Collection txnLevels = CommonUtils.safeCollection((Collection)dataSource.getInfo().getSupportedTransactionsIsolation());
        Integer levelCode = this.dataSourceDescriptor.getDefaultTransactionsIsolation();
        UIUtils.syncExec(() -> {
            this.autocommit.setSelection(this.dataSourceDescriptor.isDefaultAutoCommit());
            this.supportedLevels.clear();
            DBPTransactionIsolation defaultLevel = null;
            if (levelCode != null && !CommonUtils.isEmpty((Collection)txnLevels)) {
                for (DBPTransactionIsolation level : txnLevels) {
                    if (level.getCode() != levelCode.intValue()) continue;
                    defaultLevel = level;
                    break;
                }
            }
            for (DBPTransactionIsolation level : txnLevels) {
                if (!level.isEnabled()) continue;
                this.isolationLevel.add(level.getTitle());
                this.supportedLevels.add(level);
                if (!level.equals(defaultLevel)) continue;
                this.isolationLevel.select(this.isolationLevel.getItemCount() - 1);
            }
        });
        if (dataSource instanceof DBSObjectContainer) {
            DBSObjectContainer schemaContainer = DBUtils.getChangeableObjectContainer((DBSObjectContainer)((DBSObjectContainer)dataSource));
            try {
                ArrayList<String> schemaNames = new ArrayList<String>();
                Collection children = schemaContainer.getChildren(monitor);
                if (children != null) {
                    for (DBSObject child : children) {
                        if (!(child instanceof DBSObjectContainer)) continue;
                        schemaNames.add(child.getName());
                    }
                }
                if (!schemaNames.isEmpty()) {
                    UIUtils.syncExec(() -> {
                        if (!this.defaultSchema.isDisposed()) {
                            String oldText = this.defaultSchema.getText();
                            this.defaultSchema.removeAll();
                            for (String name : schemaNames) {
                                this.defaultSchema.add(name);
                            }
                            if (!CommonUtils.isEmpty((String)oldText)) {
                                this.defaultSchema.setText(oldText);
                            }
                        }
                    });
                }
            }
            catch (DBException e) {
                log.warn((Object)"Can't read schema list", (Throwable)e);
            }
        }
        this.txnOptionsLoaded = true;
    }

    public void deactivatePage() {
    }

    public void createControl(Composite parent) {
        this.boldFont = UIUtils.makeBoldFont((Font)parent.getFont());
        Composite group = UIUtils.createPlaceholder((Composite)parent, (int)1, (int)5);
        Group txnGroup = UIUtils.createControlGroup((Composite)group, (String)CoreMessages.dialog_connection_wizard_final_label_connection, (int)2, (int)2, (int)0);
        this.autocommit = UIUtils.createLabelCheckbox((Composite)txnGroup, (String)CoreMessages.dialog_connection_wizard_final_checkbox_auto_commit, (String)"Sets auto-commit mode for all connections", (this.dataSourceDescriptor != null && this.dataSourceDescriptor.isDefaultAutoCommit() ? 1 : 0) != 0);
        this.autocommit.setLayoutData((Object)new GridData(32));
        this.autocommit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionPageInitialization.this.isolationLevel.setEnabled(!ConnectionPageInitialization.this.autocommit.getSelection());
            }
        });
        this.isolationLevel = UIUtils.createLabelCombo((Composite)txnGroup, (String)CoreMessages.dialog_connection_wizard_final_label_isolation_level, (String)CoreMessages.dialog_connection_wizard_final_label_isolation_level_tooltip, (int)12);
        this.defaultSchema = UIUtils.createLabelCombo((Composite)txnGroup, (String)CoreMessages.dialog_connection_wizard_final_label_default_schema, (String)CoreMessages.dialog_connection_wizard_final_label_default_schema_tooltip, (int)4);
        ((GridData)this.defaultSchema.getLayoutData()).widthHint = UIUtils.getFontHeight((Control)this.defaultSchema) * 20;
        this.keepAliveInterval = UIUtils.createLabelSpinner((Composite)txnGroup, (String)CoreMessages.dialog_connection_wizard_final_label_keepalive, (String)CoreMessages.dialog_connection_wizard_final_label_keepalive_tooltip, (int)0, (int)0, (int)Short.MAX_VALUE);
        String bootstrapTooltip = CoreMessages.dialog_connection_wizard_final_label_bootstrap_tooltip;
        UIUtils.createControlLabel((Composite)txnGroup, (String)CoreMessages.dialog_connection_wizard_final_label_bootstrap_query).setToolTipText(bootstrapTooltip);
        Button queriesConfigButton = UIUtils.createPushButton((Composite)txnGroup, (String)CoreMessages.dialog_connection_wizard_configure, (Image)DBeaverIcons.getImage((DBPImage)UIIcon.SQL_SCRIPT));
        queriesConfigButton.setToolTipText(bootstrapTooltip);
        if (this.dataSourceDescriptor != null && !CommonUtils.isEmpty((Collection)this.dataSourceDescriptor.getConnectionConfiguration().getBootstrap().getInitQueries())) {
            queriesConfigButton.setFont(this.boldFont);
        }
        queriesConfigButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditBootstrapQueriesDialog dialog = new EditBootstrapQueriesDialog(ConnectionPageInitialization.this.getShell(), ConnectionPageInitialization.this.bootstrapQueries, ConnectionPageInitialization.this.ignoreBootstrapErrors);
                if (dialog.open() == 0) {
                    ConnectionPageInitialization.this.bootstrapQueries = dialog.getQueries();
                    ConnectionPageInitialization.this.ignoreBootstrapErrors = dialog.isIgnoreErrors();
                }
            }
        });
        CLabel infoLabel = UIUtils.createInfoLabel((Composite)group, (String)CoreMessages.dialog_connection_wizard_connection_init_hint);
        GridData gd = new GridData(808);
        gd.grabExcessHorizontalSpace = true;
        infoLabel.setLayoutData((Object)gd);
        infoLabel.setToolTipText(CoreMessages.dialog_connection_wizard_connection_init_hint_tip);
        this.setControl((Control)group);
        UIUtils.setHelp((Control)group, (String)"con-wizard-final");
    }

    public boolean isPageComplete() {
        return true;
    }

    @Override
    public void saveSettings(DataSourceDescriptor dataSource) {
        if (this.dataSourceDescriptor != null && !this.activated) {
            return;
        }
        try {
            dataSource.setDefaultAutoCommit(this.autocommit.getSelection(), null, true, null);
            if (this.txnOptionsLoaded) {
                int levelIndex = this.isolationLevel.getSelectionIndex();
                if (levelIndex <= 0) {
                    dataSource.setDefaultTransactionsIsolation(null);
                } else {
                    dataSource.setDefaultTransactionsIsolation(this.supportedLevels.get(levelIndex - 1));
                }
            }
        }
        catch (DBException e) {
            log.error((Object)e);
        }
        dataSource.setDefaultActiveObject(this.defaultSchema.getText());
        DBPConnectionConfiguration confConfig = dataSource.getConnectionConfiguration();
        DBPConnectionBootstrap bootstrap = confConfig.getBootstrap();
        bootstrap.setIgnoreErrors(this.ignoreBootstrapErrors);
        bootstrap.setInitQueries(this.bootstrapQueries);
        confConfig.setKeepAliveInterval(this.keepAliveInterval.getSelection());
    }

    public void setWizard(IWizard newWizard) {
        super.setWizard(newWizard);
        if (newWizard instanceof ConnectionWizard && !((ConnectionWizard)newWizard).isNew()) {
            ((ConnectionWizard)newWizard).addPropertyChangeListener(event -> {
                if ("connection-type".equals(event.getProperty())) {
                    DBPConnectionType type = (DBPConnectionType)event.getNewValue();
                    if (this.autocommit != null) {
                        this.autocommit.setSelection(type.isAutocommit());
                    }
                }
            });
        }
    }

    public void testConnection(DBCSession session) {
        try {
            this.loadDatabaseSettings(session.getProgressMonitor(), session.getDataSource());
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Database info reading", "Error reading database settings", e.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
    }
}

