/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model.generic;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericFunctionResultType;
import org.jkiss.dbeaver.ext.generic.model.GenericObjectContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericSequence;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericSynonym;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTrigger;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.model.ServerType;
import org.jkiss.dbeaver.ext.mssql.model.generic.SQLServerGenericDataSource;
import org.jkiss.dbeaver.ext.mssql.model.generic.SQLServerGenericDatabase;
import org.jkiss.dbeaver.ext.mssql.model.generic.SQLServerGenericIndex;
import org.jkiss.dbeaver.ext.mssql.model.generic.SQLServerGenericProcedure;
import org.jkiss.dbeaver.ext.mssql.model.generic.SQLServerGenericSchema;
import org.jkiss.dbeaver.ext.mssql.model.generic.SQLServerGenericTable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformProvider;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformType;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformer;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.rdb.DBSIndexType;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;

public class SQLServerMetaModel
extends GenericMetaModel
implements DBCQueryTransformProvider {
    private static final Log log = Log.getLog(SQLServerMetaModel.class);
    private final boolean sqlServer;

    public SQLServerMetaModel() {
        this(true);
    }

    public SQLServerMetaModel(boolean sqlServer) {
        this.sqlServer = sqlServer;
    }

    public boolean isSqlServer() {
        return this.sqlServer;
    }

    public SQLServerGenericDataSource createDataSourceImpl(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        return new SQLServerGenericDataSource(monitor, container, this);
    }

    public SQLServerGenericDatabase createCatalogImpl(GenericDataSource dataSource, String catalogName) {
        return new SQLServerGenericDatabase(dataSource, catalogName);
    }

    public SQLServerGenericSchema createSchemaImpl(GenericDataSource dataSource, GenericCatalog catalog, String schemaName) throws DBException {
        return new SQLServerGenericSchema(dataSource, catalog, schemaName, 0L);
    }

    public String getViewDDL(DBRProgressMonitor monitor, GenericTable sourceObject, Map<String, Object> options) throws DBException {
        return this.extractSource(monitor, (GenericDataSource)sourceObject.getDataSource(), sourceObject.getCatalog(), sourceObject.getSchema().getName(), sourceObject.getName());
    }

    public void loadProcedures(DBRProgressMonitor monitor, GenericObjectContainer container) throws DBException {
        block31: {
            if (!this.isSqlServer()) {
                GenericDataSource dataSource = container.getDataSource();
                String dbName = DBUtils.getQuotedIdentifier((DBSObject)container.getParentObject());
                try {
                    Throwable throwable = null;
                    Object var6_8 = null;
                    try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)container, (String)"Sybase procedure list");){
                        Throwable throwable2 = null;
                        Object var9_13 = null;
                        try (JDBCPreparedStatement dbStat = session.prepareStatement("select distinct so.name as proc_name,su.name as schema_name\nfrom " + dbName + ".dbo.sysobjects so, " + dbName + ".dbo.sysusers su\n" + "where so.type = 'P'\n" + "and su.uid = so.uid\n" + "and su.name=?");){
                            dbStat.setString(1, container.getName());
                            Throwable throwable3 = null;
                            Object var12_18 = null;
                            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                                while (dbResult.nextRow()) {
                                    SQLServerGenericProcedure procedure = this.createProcedureImpl((GenericStructContainer)container, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"proc_name"), null, null, DBSProcedureType.PROCEDURE, null);
                                    procedure.setSource(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"definition"));
                                    container.addProcedure((GenericProcedure)procedure);
                                }
                                break block31;
                            }
                            catch (Throwable throwable4) {
                                if (throwable3 == null) {
                                    throwable3 = throwable4;
                                } else if (throwable3 != throwable4) {
                                    throwable3.addSuppressed(throwable4);
                                }
                                throw throwable3;
                            }
                        }
                        catch (Throwable throwable5) {
                            if (throwable2 == null) {
                                throwable2 = throwable5;
                            } else if (throwable2 != throwable5) {
                                throwable2.addSuppressed(throwable5);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable6) {
                        if (throwable == null) {
                            throwable = throwable6;
                        } else if (throwable != throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e) {
                    throw new DBException((Throwable)e, (DBPDataSource)dataSource);
                }
            }
            super.loadProcedures(monitor, container);
        }
    }

    public SQLServerGenericProcedure createProcedureImpl(GenericStructContainer container, String procedureName, String specificName, String remarks, DBSProcedureType procedureType, GenericFunctionResultType functionResultType) {
        return new SQLServerGenericProcedure(container, procedureName, specificName, remarks, procedureType, functionResultType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getProcedureDDL(DBRProgressMonitor monitor, GenericProcedure sourceObject) throws DBException {
        if (!this.isSqlServer()) return this.extractSource(monitor, (GenericDataSource)sourceObject.getDataSource(), sourceObject.getCatalog(), sourceObject.getSchema().getName(), sourceObject.getName());
        if (!((GenericDataSource)sourceObject.getDataSource()).isServerVersionAtLeast(9, 0)) return this.extractSource(monitor, (GenericDataSource)sourceObject.getDataSource(), sourceObject.getCatalog(), sourceObject.getSchema().getName(), sourceObject.getName());
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)sourceObject, (String)"Read routine definition");
                try {
                    Throwable throwable2 = null;
                    Object var7_11 = null;
                    try {
                        JDBCPreparedStatement dbStat = session.prepareStatement("SELECT definition FROM " + DBUtils.getQuotedIdentifier((DBSObject)sourceObject.getCatalog()) + ".sys.sql_modules WHERE object_id=OBJECT_ID(?)");
                        try {
                            dbStat.setString(1, sourceObject.getFullyQualifiedName(DBPEvaluationContext.DML));
                            Throwable throwable3 = null;
                            Object var10_16 = null;
                            try {
                                String string;
                                block24: {
                                    JDBCResultSet dbResult = dbStat.executeQuery();
                                    if (dbResult.nextRow()) {
                                        string = dbResult.getString(1);
                                        break block24;
                                    } else {
                                        String string2 = "-- Routine '" + sourceObject.getName() + "' definition not found in ";
                                        if (dbStat != null) {
                                            dbStat.close();
                                        }
                                        if (session == null) return string2;
                                        session.close();
                                        return string2;
                                    }
                                    finally {
                                        if (dbResult == null) break block24;
                                        dbResult.close();
                                    }
                                }
                                if (dbStat != null) {
                                    dbStat.close();
                                }
                                if (session == null) return string;
                                session.close();
                                return string;
                            }
                            catch (Throwable throwable4) {
                                if (throwable3 == null) {
                                    throwable3 = throwable4;
                                    throw throwable3;
                                }
                                if (throwable3 == throwable4) throw throwable3;
                                throwable3.addSuppressed(throwable4);
                                throw throwable3;
                            }
                        }
                        catch (Throwable throwable5) {
                            if (dbStat == null) throw throwable5;
                            dbStat.close();
                            throw throwable5;
                        }
                    }
                    catch (Throwable throwable6) {
                        if (throwable2 == null) {
                            throwable2 = throwable6;
                            throw throwable2;
                        }
                        if (throwable2 == throwable6) throw throwable2;
                        throwable2.addSuppressed(throwable6);
                        throw throwable2;
                    }
                }
                catch (Throwable throwable7) {
                    if (session == null) throw throwable7;
                    session.close();
                    throw throwable7;
                }
            }
            catch (Throwable throwable8) {
                if (throwable == null) {
                    throwable = throwable8;
                    throw throwable;
                }
                if (throwable == throwable8) throw throwable;
                throwable.addSuppressed(throwable8);
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, sourceObject.getDataSource());
        }
    }

    public boolean supportsTriggers(@NotNull GenericDataSource dataSource) {
        return true;
    }

    /*
     * Exception decompiling
     */
    public List<GenericTrigger> loadTriggers(DBRProgressMonitor monitor, @NotNull GenericStructContainer container, @Nullable GenericTable table) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getTriggerDDL(@NotNull DBRProgressMonitor monitor, @NotNull GenericTrigger trigger) throws DBException {
        GenericTable table = trigger.getTable();
        assert (table != null);
        return this.extractSource(monitor, (GenericDataSource)table.getDataSource(), table.getCatalog(), table.getSchema().getName(), trigger.getName());
    }

    @Nullable
    public DBCQueryTransformer createQueryTransformer(@NotNull DBCQueryTransformType type) {
        return null;
    }

    /*
     * Exception decompiling
     */
    private String extractSource(DBRProgressMonitor monitor, GenericDataSource dataSource, GenericCatalog catalog, String schema, String name) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[TRYBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ServerType getServerType() {
        return this.sqlServer ? ServerType.SQL_SERVER : ServerType.SYBASE;
    }

    public SQLServerGenericIndex createIndexImpl(GenericTable table, boolean nonUnique, String qualifier, long cardinality, String indexName, DBSIndexType indexType, boolean persisted) {
        return new SQLServerGenericIndex(table, nonUnique, qualifier, cardinality, indexName, indexType, persisted);
    }

    public String getAutoIncrementClause(GenericTableColumn column) {
        return "IDENTITY(1,1)";
    }

    public boolean useCatalogInObjectNames() {
        return false;
    }

    public List<GenericSchema> loadSchemas(JDBCSession session, GenericDataSource dataSource, GenericCatalog catalog) throws DBException {
        boolean showAllSchemas = SQLServerUtils.isShowAllSchemas((DBPDataSource)dataSource);
        DBSObjectFilter schemaFilters = dataSource.getContainer().getObjectFilter(GenericSchema.class, (DBSObject)catalog, false);
        String sysSchema = SQLServerUtils.getSystemSchemaFQN((JDBCDataSource)dataSource, catalog.getName(), this.getSystemSchema());
        String sql = showAllSchemas ? (this.getServerType() == ServerType.SQL_SERVER && dataSource.isServerVersionAtLeast(9, 0) ? "SELECT * FROM " + sysSchema + ".schemas" : "SELECT * FROM " + sysSchema + ".sysusers") : (this.getServerType() == ServerType.SQL_SERVER ? "SELECT DISTINCT s.*\nFROM " + sysSchema + ".schemas s, " + sysSchema + ".sysobjects o\n" + "WHERE s.schema_id=o.uid\n" + "ORDER BY 1" : "SELECT DISTINCT u.name,u.uid\nFROM " + sysSchema + ".sysusers u, " + sysSchema + ".sysobjects o\n" + "WHERE u.uid=o.uid\n" + "ORDER BY 1");
        boolean schemaReadFailed = false;
        ArrayList<GenericSchema> result = new ArrayList<GenericSchema>();
        try {
            Throwable throwable = null;
            Object var11_13 = null;
            try (JDBCPreparedStatement dbStat = session.prepareStatement(sql);){
                Throwable throwable2 = null;
                Object var14_18 = null;
                try (JDBCResultSet dbResult = dbStat.executeQuery();){
                    while (dbResult.next()) {
                        String name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"name");
                        if (name == null) continue;
                        name = name.trim();
                        if (schemaFilters != null && !schemaFilters.matches(name)) continue;
                        long schemaId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"schema_id");
                        SQLServerGenericSchema schema = new SQLServerGenericSchema(dataSource, catalog, name, schemaId);
                        result.add(schema);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            if (dataSource.discoverErrorType((Throwable)e) == DBPErrorAssistant.ErrorType.CONNECTION_LOST) {
                throw new DBException((Throwable)e, (DBPDataSource)dataSource);
            }
            log.warn((Object)"Schema read failed: empty list returned. Try generic method.", (Throwable)e);
            schemaReadFailed = true;
        }
        if (result.isEmpty()) {
            if (!schemaReadFailed && !showAllSchemas) {
                result.add(new GenericSchema(dataSource, catalog, "dbo"));
            } else {
                return super.loadSchemas(session, dataSource, catalog);
            }
        }
        return result;
    }

    public boolean supportsSequences(GenericDataSource dataSource) {
        return this.getServerType() == ServerType.SQL_SERVER;
    }

    /*
     * Exception decompiling
     */
    public List<GenericSequence> loadSequences(DBRProgressMonitor monitor, GenericStructContainer container) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean supportsSynonyms(GenericDataSource dataSource) {
        return this.isSqlServer();
    }

    /*
     * Exception decompiling
     */
    public List<? extends GenericSynonym> loadSynonyms(DBRProgressMonitor monitor, GenericStructContainer container) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public SQLServerGenericTable createTableImpl(GenericStructContainer container, String tableName, String tableType, JDBCResultSet dbResult) {
        return new SQLServerGenericTable(container, tableName, tableType, dbResult);
    }

    public boolean isSystemTable(GenericTable table) {
        return table.getSchema() != null && this.getSystemSchema().equals(table.getSchema().getName()) && table.getName().startsWith("sys");
    }

    @NotNull
    private String getSystemSchema() {
        return this.sqlServer ? "sys" : "dbo";
    }
}

