/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.views;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ext.oracle.OracleMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.preferences.PreferenceStoreDelegate;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;

public class PrefPageOracle
extends TargetPrefPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.oracle.general";
    private Text explainTableText;
    private Button rowidSupportCheck;
    private Button enableDbmsOuputCheck;
    private Button readAllSynonymsCheck;
    private Button disableScriptEscapeProcessingCheck;

    public PrefPageOracle() {
        this.setPreferenceStore((IPreferenceStore)new PreferenceStoreDelegate(DBWorkbench.getPlatform().getPreferenceStore()));
    }

    protected boolean hasDataSourceSpecificOptions(DBPDataSourceContainer dataSourceDescriptor) {
        DBPPreferenceStore store = dataSourceDescriptor.getPreferenceStore();
        return store.contains("oracle.explain.table") || store.contains("oracle.support.rowid") || store.contains("oracle.dbms.output") || store.contains("oracle.read.all.synonyms") || store.contains("oracle.disable.script.escape");
    }

    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    protected Control createPreferenceContent(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        Group planGroup = UIUtils.createControlGroup((Composite)composite, (String)OracleMessages.pref_page_oracle_legend_executin_plan, (int)2, (int)768, (int)0);
        Label descLabel = new Label((Composite)planGroup, 64);
        descLabel.setText(OracleMessages.pref_page_oracle_label_by_default_plan_table);
        GridData gd = new GridData(32);
        gd.horizontalSpan = 2;
        descLabel.setLayoutData((Object)gd);
        this.explainTableText = UIUtils.createLabelText((Composite)planGroup, (String)OracleMessages.pref_page_oracle_label_plan_table, (String)"", (int)2048, (Object)new GridData(768));
        Group miscGroup = UIUtils.createControlGroup((Composite)composite, (String)OracleMessages.pref_page_oracle_legend_misc, (int)1, (int)768, (int)0);
        this.rowidSupportCheck = UIUtils.createCheckbox((Composite)miscGroup, (String)OracleMessages.pref_page_oracle_checkbox_use_rowid_to_identify_rows, (boolean)true);
        this.enableDbmsOuputCheck = UIUtils.createCheckbox((Composite)miscGroup, (String)OracleMessages.pref_page_oracle_checkbox_enable_dbms_output, (boolean)true);
        this.readAllSynonymsCheck = UIUtils.createCheckbox((Composite)miscGroup, (String)OracleMessages.pref_page_oracle_checkbox_read_all_synonyms, (String)OracleMessages.pref_page_oracle_label_if_unchecked_java_classes, (boolean)true, (int)1);
        this.disableScriptEscapeProcessingCheck = UIUtils.createCheckbox((Composite)miscGroup, (String)OracleMessages.pref_page_oracle_checkbox_disable_escape_processing, (String)OracleMessages.pref_page_oracle_label_disable_client_side_parser, (boolean)true, (int)1);
        return composite;
    }

    protected void loadPreferences(DBPPreferenceStore store) {
        this.explainTableText.setText(store.getString("oracle.explain.table"));
        this.rowidSupportCheck.setSelection(store.getBoolean("oracle.support.rowid"));
        this.enableDbmsOuputCheck.setSelection(store.getBoolean("oracle.dbms.output"));
        this.readAllSynonymsCheck.setSelection(store.getBoolean("oracle.read.all.synonyms"));
        this.disableScriptEscapeProcessingCheck.setSelection(store.getBoolean("oracle.disable.script.escape"));
    }

    protected void savePreferences(DBPPreferenceStore store) {
        store.setValue("oracle.explain.table", this.explainTableText.getText());
        store.setValue("oracle.support.rowid", this.rowidSupportCheck.getSelection());
        store.setValue("oracle.dbms.output", this.enableDbmsOuputCheck.getSelection());
        store.setValue("oracle.read.all.synonyms", this.readAllSynonymsCheck.getSelection());
        store.setValue("oracle.disable.script.escape", this.disableScriptEscapeProcessingCheck.getSelection());
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
    }

    protected void clearPreferences(DBPPreferenceStore store) {
        store.setToDefault("oracle.explain.table");
        store.setToDefault("oracle.support.rowid");
        store.setToDefault("oracle.dbms.output");
        store.setToDefault("oracle.read.all.synonyms");
        store.setToDefault("oracle.disable.script.escape");
    }

    protected String getPropertyPageID() {
        return PAGE_ID;
    }
}

