/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transport.http;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.client.utils.URIUtils;

final class UriUtils {
    UriUtils() {
    }

    public static URI resolve(URI base, URI ref2) {
        String path2 = ref2.getRawPath();
        if (!(path2 == null || path2.length() <= 0 || (path2 = base.getRawPath()) != null && path2.endsWith("/"))) {
            try {
                base = new URI(base.getScheme(), base.getAuthority(), base.getPath() + '/', null, null);
            }
            catch (URISyntaxException e2) {
                throw new IllegalStateException(e2);
            }
        }
        return URIUtils.resolve(base, ref2);
    }

    public static List<URI> getDirectories(URI base, URI uri) {
        ArrayList<URI> dirs = new ArrayList<URI>();
        URI dir2 = uri.resolve(".");
        while (!UriUtils.isBase(base, dir2)) {
            dirs.add(dir2);
            dir2 = dir2.resolve("..");
        }
        return dirs;
    }

    private static boolean isBase(URI base, URI uri) {
        URI rel;
        String path2 = uri.getRawPath();
        if (path2 == null || "/".equals(path2)) {
            return true;
        }
        return base != null && ((rel = base.relativize(uri)).getRawPath() == null || rel.getRawPath().length() <= 0 || rel.equals(uri));
    }
}

