Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _roaster = require('roaster');

var _roaster2 = _interopRequireDefault(_roaster);

var _dompurify = require('dompurify');

var _dompurify2 = _interopRequireDefault(_dompurify);

function sanitize(html, readmeSrc) {
  var temporaryContainer = document.createElement('div');
  temporaryContainer.innerHTML = html;

  for (var checkbox of temporaryContainer.querySelectorAll('input[type="checkbox"]')) {
    checkbox.setAttribute('disabled', '');
  }

  var path = require('path');

  for (var image of temporaryContainer.querySelectorAll('img')) {
    var imageSrc = image.getAttribute('src');

    var changeImageSrc = true;

    // If src contains a protocol then it must be absolute
    if (/^(?:[a-z]+:)?\/\//i.test(imageSrc)) {
      changeImageSrc = false;
    }

    // If src contains a base64 encoded image it must be left unchanged
    if (/^data:image\/.*;base64/i.test(imageSrc)) {
      changeImageSrc = false;
    }

    // If path is absolute on file system it must be a local file, e.g. emoji
    if (path.isAbsolute(imageSrc)) {
      changeImageSrc = false;
    }

    // If imageSrc needs changing and readmeSrc isn't undefined (i.e. if package was unpublished)
    if (changeImageSrc && readmeSrc) {
      if (path.isAbsolute(readmeSrc)) {
        // If repoUrl is a local path (i.e. package is installed)
        image.setAttribute('src', path.join(readmeSrc, imageSrc));
      } else {
        // If repoUrl is a URL (i.e. package isn't installed)
        image.setAttribute('src', new URL(imageSrc, readmeSrc));
      }
    }
  }

  return (0, _dompurify2['default'])().sanitize(temporaryContainer.innerHTML);
}

// Displays the readme for a package, if it has one
// TODO Decide to keep this or current button-to-new-tab view

var PackageReadmeView = (function () {
  function PackageReadmeView(readme, readmeSrc) {
    var _this = this;

    _classCallCheck(this, PackageReadmeView);

    this.element = document.createElement('section');
    this.element.classList.add('section');

    var container = document.createElement('div');
    container.classList.add('section-container');

    var heading = document.createElement('div');
    heading.classList.add('section-heading', 'icon', 'icon-book');
    heading.textContent = 'README';
    container.appendChild(heading);

    this.packageReadme = document.createElement('div');
    this.packageReadme.classList.add('package-readme', 'native-key-bindings');
    this.packageReadme.tabIndex = -1;
    container.appendChild(this.packageReadme);
    this.element.appendChild(container);

    (0, _roaster2['default'])(readme || '### No README.', function (err, content) {
      if (err) {
        _this.packageReadme.innerHTML = '<h3>Error parsing README</h3>';
      } else {
        _this.packageReadme.innerHTML = sanitize(content, readmeSrc);
      }
    });
  }

  _createClass(PackageReadmeView, [{
    key: 'destroy',
    value: function destroy() {
      this.element.remove();
    }
  }]);

  return PackageReadmeView;
})();

exports['default'] = PackageReadmeView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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