"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareIssueishListController = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactRelay = require("react-relay");

var _propTypes2 = require("../prop-types");

var _issueishListView = _interopRequireDefault(require("../views/issueish-list-view"));

var _issueish = _interopRequireDefault(require("../models/issueish"));

var _electron = require("electron");

var _reporterProxy = require("../reporter-proxy");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const {
  Menu,
  MenuItem
} = _electron.remote;

const StatePropType = _propTypes["default"].oneOf(['EXPECTED', 'PENDING', 'SUCCESS', 'ERROR', 'FAILURE']);

class BareIssueishListController extends _react["default"].Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "openOnGitHub", url => {
      return new Promise((resolve, reject) => {
        _electron.shell.openExternal(url, {}, err => {
          if (err) {
            reject(err);
          } else {
            resolve();
            (0, _reporterProxy.addEvent)('open-issueish-in-browser', {
              "package": 'github',
              component: this.constructor.name
            });
          }
        });
      });
    });

    _defineProperty(this, "showActionsMenu",
    /* istanbul ignore next */
    issueish => {
      const menu = new Menu();
      menu.append(new MenuItem({
        label: 'See reviews',
        click: () => this.props.onOpenReviews(issueish)
      }));
      menu.append(new MenuItem({
        label: 'Open on GitHub',
        click: () => this.openOnGitHub(issueish.getGitHubURL())
      }));
      menu.popup(_electron.remote.getCurrentWindow());
    });

    this.state = {};
  }

  static getDerivedStateFromProps(props, state) {
    if (props.results === null) {
      return {
        lastResults: null,
        issueishes: []
      };
    }

    if (props.results !== state.lastResults) {
      return {
        lastResults: props.results,
        issueishes: props.results.map(node => new _issueish["default"](node)).filter(props.resultFilter)
      };
    }

    return null;
  }

  render() {
    return _react["default"].createElement(_issueishListView["default"], {
      title: this.props.title,
      isLoading: this.props.isLoading,
      total: this.props.total,
      issueishes: this.state.issueishes,
      error: this.props.error,
      needReviewsButton: this.props.needReviewsButton,
      onIssueishClick: this.props.onOpenIssueish,
      onMoreClick: this.props.onOpenMore,
      openReviews: this.props.onOpenReviews,
      openOnGitHub: this.openOnGitHub,
      showActionsMenu: this.showActionsMenu,
      emptyComponent: this.props.emptyComponent
    });
  }

}

exports.BareIssueishListController = BareIssueishListController;

_defineProperty(BareIssueishListController, "propTypes", {
  results: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    number: _propTypes["default"].number.isRequired,
    title: _propTypes["default"].string.isRequired,
    url: _propTypes["default"].string.isRequired,
    author: _propTypes["default"].shape({
      login: _propTypes["default"].string.isRequired,
      avatarUrl: _propTypes["default"].string.isRequired
    }),
    createdAt: _propTypes["default"].string.isRequired,
    headRefName: _propTypes["default"].string.isRequired,
    repository: _propTypes["default"].shape({
      id: _propTypes["default"].string.isRequired,
      name: _propTypes["default"].string.isRequired,
      owner: _propTypes["default"].shape({
        login: _propTypes["default"].string.isRequired
      }).isRequired
    }).isRequired,
    commits: _propTypes["default"].shape({
      nodes: _propTypes["default"].arrayOf(_propTypes["default"].shape({
        commit: _propTypes["default"].shape({
          status: _propTypes["default"].shape({
            contexts: _propTypes["default"].arrayOf(_propTypes["default"].shape({
              state: StatePropType.isRequired
            }).isRequired).isRequired
          })
        })
      }))
    })
  })),
  total: _propTypes["default"].number.isRequired,
  isLoading: _propTypes["default"].bool.isRequired,
  title: _propTypes["default"].string.isRequired,
  error: _propTypes["default"].object,
  resultFilter: _propTypes["default"].func,
  onOpenIssueish: _propTypes["default"].func.isRequired,
  onOpenReviews: _propTypes["default"].func.isRequired,
  onOpenMore: _propTypes["default"].func,
  emptyComponent: _propTypes["default"].func,
  workspace: _propTypes["default"].object,
  endpoint: _propTypes2.EndpointPropType,
  needReviewsButton: _propTypes["default"].bool
});

_defineProperty(BareIssueishListController, "defaultProps", {
  results: [],
  total: 0,
  resultFilter: () => true
});

var _default = (0, _reactRelay.createFragmentContainer)(BareIssueishListController, {
  results: function () {
    const node = require("./__generated__/issueishListController_results.graphql");

    if (node.hash && node.hash !== "5cd992367edc948370db9a3182449e06") {
      console.error("The definition of 'issueishListController_results' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/issueishListController_results.graphql");
  }
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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