"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _yubikiri = _interopRequireDefault(require("yubikiri"));

var _helpers = require("../helpers");

var _commit = require("../models/commit");

var _branch = require("../models/branch");

var _observeModel = _interopRequireDefault(require("../views/observe-model"));

var _gitTabController = _interopRequireDefault(require("../controllers/git-tab-controller"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const DEFAULT_REPO_DATA = {
  lastCommit: _commit.nullCommit,
  recentCommits: [],
  isMerging: false,
  isRebasing: false,
  hasUndoHistory: false,
  currentBranch: _branch.nullBranch,
  unstagedChanges: [],
  stagedChanges: [],
  mergeConflicts: [],
  workingDirectoryPath: null,
  mergeMessage: null,
  fetchInProgress: true
};

class GitTabContainer extends _react["default"].Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'fetchData');
  }

  fetchData(repository) {
    return (0, _yubikiri["default"])({
      lastCommit: repository.getLastCommit(),
      recentCommits: repository.getRecentCommits({
        max: 10
      }),
      isMerging: repository.isMerging(),
      isRebasing: repository.isRebasing(),
      hasUndoHistory: repository.hasDiscardHistory(),
      currentBranch: repository.getCurrentBranch(),
      unstagedChanges: repository.getUnstagedChanges(),
      stagedChanges: repository.getStagedChanges(),
      mergeConflicts: repository.getMergeConflicts(),
      workingDirectoryPath: repository.getWorkingDirectoryPath(),
      mergeMessage: async query => {
        const isMerging = await query.isMerging;
        return isMerging ? repository.getMergeMessage() : null;
      },
      fetchInProgress: false
    });
  }

  render() {
    return _react["default"].createElement(_observeModel["default"], {
      model: this.props.repository,
      fetchData: this.fetchData
    }, data => _react["default"].createElement(_gitTabController["default"], _extends({}, this.props, data || DEFAULT_REPO_DATA)));
  }

}

exports["default"] = GitTabContainer;

_defineProperty(GitTabContainer, "propTypes", {
  repository: _propTypes["default"].object.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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