/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModelKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.inspections.unresolvedReference.PyUnresolvedReferencesInspection;
import org.jetbrains.annotations.NotNull;

public class AddIgnoredIdentifierQuickFix
implements LocalQuickFix,
LowPriorityAction {
    public static final String END_WILDCARD = ".*";
    @NotNull
    private final QualifiedName myIdentifier;
    private final boolean myIgnoreAllAttributes;

    public AddIgnoredIdentifierQuickFix(@NotNull QualifiedName identifier, boolean ignoreAllAttributes) {
        if (identifier == null) {
            AddIgnoredIdentifierQuickFix.$$$reportNull$$$0(0);
        }
        this.myIdentifier = identifier;
        this.myIgnoreAllAttributes = ignoreAllAttributes;
    }

    @NotNull
    public String getName() {
        if (this.myIgnoreAllAttributes) {
            String string = "Mark all unresolved attributes of '" + this.myIdentifier + "' as ignored";
            if (string == null) {
                AddIgnoredIdentifierQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = "Ignore unresolved reference '" + this.myIdentifier + "'";
        if (string == null) {
            AddIgnoredIdentifierQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Ignore unresolved reference" == null) {
            AddIgnoredIdentifierQuickFix.$$$reportNull$$$0(3);
        }
        return "Ignore unresolved reference";
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            AddIgnoredIdentifierQuickFix.$$$reportNull$$$0(4);
        }
        if (descriptor2 == null) {
            AddIgnoredIdentifierQuickFix.$$$reportNull$$$0(5);
        }
        PsiElement context = descriptor2.getPsiElement();
        InspectionProfileModifiableModelKt.modifyAndCommitProjectProfile((Project)project, model -> {
            PyUnresolvedReferencesInspection inspection = (PyUnresolvedReferencesInspection)model.getUnwrappedTool(PyUnresolvedReferencesInspection.class.getSimpleName(), context);
            String name = this.myIdentifier.toString();
            if (this.myIgnoreAllAttributes) {
                name = name + END_WILDCARD;
            }
            assert (inspection != null);
            if (!inspection.ignoredIdentifiers.contains(name)) {
                inspection.ignoredIdentifiers.add(name);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/AddIgnoredIdentifierQuickFix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/AddIgnoredIdentifierQuickFix";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

