/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.testIntegration;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.testIntegration.TestCreator;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.codeInsight.testIntegration.CreateTestAction;
import com.jetbrains.python.codeInsight.testIntegration.CreateTestDialog;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyTestCreator
implements TestCreator {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.python.codeInsight.testIntegration.PyTestCreator");

    public boolean isAvailable(Project project, Editor editor, PsiFile file) {
        CreateTestAction action = new CreateTestAction();
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        if (element != null) {
            return action.isAvailable(project, editor, element);
        }
        return false;
    }

    public void createTest(Project project, Editor editor, PsiFile file) {
        try {
            CreateTestAction action = new CreateTestAction();
            PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
            if (action.isAvailable(project, editor, element)) {
                action.invoke(project, editor, file.getContainingFile());
            }
        }
        catch (IncorrectOperationException e) {
            LOG.warn((Throwable)e);
        }
    }

    static PsiFile generateTestAndNavigate(final @NotNull Project project, final @NotNull CreateTestDialog dialog) {
        if (project == null) {
            PyTestCreator.$$$reportNull$$$0(0);
        }
        if (dialog == null) {
            PyTestCreator.$$$reportNull$$$0(1);
        }
        return (PsiFile)PostprocessReformattingAspect.getInstance((Project)project).postponeFormattingInside(() -> (PsiFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<PsiFile>(){

            public PsiFile compute() {
                try {
                    PyElement testClass = PyTestCreator.generateTest(project, dialog);
                    testClass.navigate(false);
                    return testClass.getContainingFile();
                }
                catch (IncorrectOperationException e) {
                    LOG.warn((Throwable)e);
                    return null;
                }
            }
        }));
    }

    @NotNull
    static PyElement generateTest(@NotNull Project project, @NotNull CreateTestDialog dialog) {
        if (project == null) {
            PyTestCreator.$$$reportNull$$$0(2);
        }
        if (dialog == null) {
            PyTestCreator.$$$reportNull$$$0(3);
        }
        IdeDocumentHistory.getInstance((Project)project).includeCurrentPlaceAsChangePlace();
        String fileName = dialog.getFileName();
        if (!fileName.endsWith(".py")) {
            fileName = fileName + "." + PythonFileType.INSTANCE.getDefaultExtension();
        }
        StringBuilder fileText = new StringBuilder();
        fileText.append("class ").append(dialog.getClassName()).append("(TestCase):\n\t");
        List<String> methods = dialog.getMethods();
        if (methods.size() == 0) {
            fileText.append("pass\n");
        }
        for (String method : methods) {
            fileText.append("def ").append(method).append("(self):\n\tself.fail()\n\n\t");
        }
        PyFile psiFile = PyUtil.getOrCreateFile(dialog.getTargetDir() + "/" + fileName, project);
        AddImportHelper.addOrUpdateFromImportStatement(psiFile, "unittest", "TestCase", null, AddImportHelper.ImportPriority.BUILTIN, null);
        PyElement createdClass = PyElementGenerator.getInstance(project).createFromText(LanguageLevel.forElement((PsiElement)psiFile), PyClass.class, fileText.toString());
        createdClass = (PyElement)psiFile.addAfter((PsiElement)createdClass, psiFile.getLastChild());
        PostprocessReformattingAspect.getInstance((Project)project).doPostponedFormatting(psiFile.getViewProvider());
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)psiFile);
        PyElement pyElement = createdClass;
        if (pyElement == null) {
            PyTestCreator.$$$reportNull$$$0(4);
        }
        return pyElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialog";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/testIntegration/PyTestCreator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/testIntegration/PyTestCreator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "generateTest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateTestAndNavigate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "generateTest";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

