/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import java.awt.EventQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Obsolescent;

public abstract class Invoker
implements Disposable {
    private static final int THRESHOLD = Integer.MAX_VALUE;
    private static final Logger LOG = Logger.getInstance(Invoker.class);
    private static final AtomicInteger UID = new AtomicInteger();
    private final ConcurrentHashMap<AsyncPromise<?>, ProgressIndicatorBase> indicators;
    private final AtomicInteger count;
    private final String description;
    private volatile boolean disposed;

    private Invoker(@NotNull String prefix, @NotNull Disposable parent) {
        if (prefix == null) {
            Invoker.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            Invoker.$$$reportNull$$$0(1);
        }
        this.indicators = new ConcurrentHashMap();
        this.count = new AtomicInteger();
        this.description = UID.getAndIncrement() + ".Invoker." + prefix + ": " + parent;
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    public String toString() {
        return this.description;
    }

    public void dispose() {
        this.disposed = true;
        while (!this.indicators.isEmpty()) {
            ((ConcurrentHashMap.KeySetView)this.indicators.keySet()).forEach(AsyncPromise::cancel);
        }
    }

    public abstract boolean isValidThread();

    @NotNull
    public final CancellablePromise<?> invokeLater(@NotNull Runnable task) {
        if (task == null) {
            Invoker.$$$reportNull$$$0(2);
        }
        CancellablePromise<?> cancellablePromise = this.invokeLater(task, 0);
        if (cancellablePromise == null) {
            Invoker.$$$reportNull$$$0(3);
        }
        return cancellablePromise;
    }

    @NotNull
    public final CancellablePromise<?> invokeLater(@NotNull Runnable task, int delay) {
        if (task == null) {
            Invoker.$$$reportNull$$$0(4);
        }
        if (delay < 0) {
            throw new IllegalArgumentException("delay must be non-negative: " + delay);
        }
        AsyncPromise promise2 = new AsyncPromise();
        if (this.canInvoke(task, promise2)) {
            this.count.incrementAndGet();
            this.offer(() -> this.invokeSafely(task, promise2, 0), delay);
        }
        AsyncPromise asyncPromise = promise2;
        if (asyncPromise == null) {
            Invoker.$$$reportNull$$$0(5);
        }
        return asyncPromise;
    }

    @NotNull
    public final CancellablePromise<?> runOrInvokeLater(@NotNull Runnable task) {
        if (task == null) {
            Invoker.$$$reportNull$$$0(6);
        }
        if (this.isValidThread()) {
            this.count.incrementAndGet();
            AsyncPromise promise2 = new AsyncPromise();
            this.invokeSafely(task, promise2, 0);
            AsyncPromise asyncPromise = promise2;
            if (asyncPromise == null) {
                Invoker.$$$reportNull$$$0(7);
            }
            return asyncPromise;
        }
        CancellablePromise<?> cancellablePromise = this.invokeLater(task);
        if (cancellablePromise == null) {
            Invoker.$$$reportNull$$$0(8);
        }
        return cancellablePromise;
    }

    @Deprecated
    public final void invokeLaterIfNeeded(@NotNull Runnable task) {
        if (task == null) {
            Invoker.$$$reportNull$$$0(9);
        }
        this.runOrInvokeLater(task);
    }

    public final int getTaskCount() {
        return this.disposed ? 0 : this.count.get();
    }

    abstract void offer(@NotNull Runnable var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeSafely(@NotNull Runnable task, @NotNull AsyncPromise<?> promise2, int attempt) {
        if (task == null) {
            Invoker.$$$reportNull$$$0(10);
        }
        if (promise2 == null) {
            Invoker.$$$reportNull$$$0(11);
        }
        try {
            if (this.canInvoke(task, promise2)) {
                if (ApplicationManager.getApplication() == null) {
                    task.run();
                } else if (EventQueue.isDispatchThread()) {
                    ProgressManager.getInstance().runProcess(task, (ProgressIndicator)this.indicator(promise2));
                } else if (ApplicationManager.getApplication().isReadAccessAllowed()) {
                    if (((ApplicationEx)ApplicationManager.getApplication()).isWriteActionPending()) {
                        throw new ProcessCanceledException();
                    }
                    ProgressManager.getInstance().runProcess(task, (ProgressIndicator)this.indicator(promise2));
                } else {
                    while (!ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(task, this.indicator(promise2))) {
                        if (!this.canInvoke(task, promise2)) {
                            return;
                        }
                        ProgressIndicatorUtils.yieldToPendingWriteActions();
                        if (!this.canRestart(task, promise2, attempt)) {
                            return;
                        }
                        LOG.debug("Task is restarted");
                        ++attempt;
                    }
                }
                promise2.setResult(null);
            }
        }
        catch (ProcessCanceledException | IndexNotReadyException exception) {
            if (this.canRestart(task, promise2, attempt)) {
                this.count.incrementAndGet();
                int nextAttempt = attempt + 1;
                this.offer(() -> this.invokeSafely(task, promise2, nextAttempt), 10);
                LOG.debug("Task is restarted");
            }
        }
        catch (Throwable throwable) {
            try {
                LOG.error(throwable);
            }
            finally {
                promise2.setError(throwable);
            }
        }
        finally {
            this.count.decrementAndGet();
        }
    }

    private boolean canRestart(@NotNull Runnable task, @NotNull AsyncPromise<?> promise2, int attempt) {
        if (task == null) {
            Invoker.$$$reportNull$$$0(12);
        }
        if (promise2 == null) {
            Invoker.$$$reportNull$$$0(13);
        }
        LOG.debug("Task is canceled");
        if (attempt < Integer.MAX_VALUE) {
            return this.canInvoke(task, promise2);
        }
        LOG.warn("Task is always canceled: " + task);
        promise2.setError("timeout");
        return false;
    }

    private boolean canInvoke(@NotNull Runnable task, @NotNull AsyncPromise<?> promise2) {
        Obsolescent obsolescent;
        if (task == null) {
            Invoker.$$$reportNull$$$0(14);
        }
        if (promise2 == null) {
            Invoker.$$$reportNull$$$0(15);
        }
        if (promise2.isDone()) {
            LOG.debug("Promise is cancelled: ", new Object[]{promise2.isCancelled()});
            return false;
        }
        if (this.disposed) {
            LOG.debug("Invoker is disposed");
            promise2.setError("disposed");
            return false;
        }
        if (task instanceof Obsolescent && (obsolescent = (Obsolescent)task).isObsolete()) {
            LOG.debug("Task is obsolete");
            promise2.setError("obsolete");
            return false;
        }
        return true;
    }

    @NotNull
    private ProgressIndicatorBase indicator(@NotNull AsyncPromise<?> promise2) {
        ProgressIndicatorBase indicator;
        if (promise2 == null) {
            Invoker.$$$reportNull$$$0(16);
        }
        if ((indicator = this.indicators.get(promise2)) == null) {
            indicator = new ProgressIndicatorBase(true);
            ProgressIndicatorBase old = this.indicators.put(promise2, indicator);
            if (old != null) {
                LOG.error("the same task is running in parallel");
            }
            promise2.onProcessed(done -> this.indicators.remove(promise2).cancel());
        }
        ProgressIndicatorBase progressIndicatorBase = indicator;
        if (progressIndicatorBase == null) {
            Invoker.$$$reportNull$$$0(17);
        }
        return progressIndicatorBase;
    }

    private static void schedule(ScheduledExecutorService executor, Runnable runnable2, int delay) {
        if (delay > 0) {
            executor.schedule(runnable2, (long)delay, TimeUnit.MILLISECONDS);
        } else {
            executor.execute(runnable2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/concurrency/Invoker";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "promise";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/concurrency/Invoker";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeLater";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "runOrInvokeLater";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invokeLater";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 17: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runOrInvokeLater";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invokeLaterIfNeeded";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "invokeSafely";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "canRestart";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "canInvoke";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "indicator";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class BackgroundThread
    extends Invoker {
        private final ScheduledExecutorService executor;
        private volatile Thread thread;

        public BackgroundThread(@NotNull Disposable parent) {
            if (parent == null) {
                BackgroundThread.$$$reportNull$$$0(0);
            }
            super("Background.Thread", parent);
            this.executor = AppExecutorUtil.createBoundedScheduledExecutorService((String)this.toString(), (int)1);
        }

        @Override
        public void dispose() {
            super.dispose();
            this.executor.shutdown();
        }

        @Override
        public boolean isValidThread() {
            return this.thread == Thread.currentThread();
        }

        @Override
        void offer(@NotNull Runnable runnable2, int delay) {
            if (runnable2 == null) {
                BackgroundThread.$$$reportNull$$$0(1);
            }
            Invoker.schedule(this.executor, () -> {
                if (this.thread != null) {
                    LOG.error("unexpected thread: " + this.thread);
                }
                try {
                    this.thread = Thread.currentThread();
                    runnable2.run();
                }
                finally {
                    this.thread = null;
                }
            }, delay);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/concurrency/Invoker$BackgroundThread";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "offer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class BackgroundPool
    extends Invoker {
        public BackgroundPool(@NotNull Disposable parent) {
            if (parent == null) {
                BackgroundPool.$$$reportNull$$$0(0);
            }
            super("Background.Pool", parent);
        }

        @Override
        public boolean isValidThread() {
            return !EventQueue.isDispatchThread();
        }

        @Override
        void offer(@NotNull Runnable runnable2, int delay) {
            if (runnable2 == null) {
                BackgroundPool.$$$reportNull$$$0(1);
            }
            Invoker.schedule(AppExecutorUtil.getAppScheduledExecutorService(), runnable2, delay);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/concurrency/Invoker$BackgroundPool";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "offer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class EDT
    extends Invoker {
        public EDT(@NotNull Disposable parent) {
            if (parent == null) {
                EDT.$$$reportNull$$$0(0);
            }
            super("EDT", parent);
        }

        @Override
        public boolean isValidThread() {
            return EventQueue.isDispatchThread();
        }

        @Override
        void offer(@NotNull Runnable runnable2, int delay) {
            if (runnable2 == null) {
                EDT.$$$reportNull$$$0(1);
            }
            if (delay > 0) {
                EdtExecutorService.getScheduledExecutorInstance().schedule(runnable2, (long)delay, TimeUnit.MILLISECONDS);
            } else {
                EdtExecutorService.getInstance().execute(runnable2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/concurrency/Invoker$EDT";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "offer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

