# ALPNProtocolResolver
<span class="source-link">[[Source]](src/stdlib-ssl/alpn.md#L13)</span>

Controls the protocol name to be chosen for incomming SSLConnections using the ALPN extension.


```pony
interface box ALPNProtocolResolver
```

## Public Functions

### resolve
<span class="source-link">[[Source]](src/stdlib-ssl/alpn.md#L17)</span>


```pony
fun box resolve(
  advertised: Array[String val] val)
: (String val | ALPNNoAck val | ALPNWarning val | 
    ALPNFatal val)
```
#### Parameters

*   advertised: [Array](builtin-Array.md)\[[String](builtin-String.md) val\] val

#### Returns

* ([String](builtin-String.md) val | [ALPNNoAck](stdlib-ssl-ALPNNoAck.md) val | [ALPNWarning](stdlib-ssl-ALPNWarning.md) val | 
    [ALPNFatal](stdlib-ssl-ALPNFatal.md) val)

---

