/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.support.prefix;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.sejda.core.support.prefix.model.NameGenerationRequest;
import org.sejda.core.support.prefix.processor.PrefixTypesChain;
import org.sejda.core.support.prefix.processor.PrefixUtils;

public final class NameGenerator {
    private String prefix;
    private PrefixTypesChain prefixTypesChain;

    private NameGenerator(String prefix) {
        this.prefix = StringUtils.defaultString((String)prefix);
        this.prefixTypesChain = new PrefixTypesChain(prefix);
    }

    public static NameGenerator nameGenerator(String prefix) {
        return new NameGenerator(prefix);
    }

    public String generate(NameGenerationRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("Unable to generate a name for a null request.");
        }
        return PrefixUtils.toSafeFilename(this.prefixTypesChain.process(this.prefix, Optional.ofNullable(request).orElseGet(() -> NameGenerationRequest.nameRequest())));
    }
}

