/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.views;

import java.awt.Graphics2D;
import java.lang.reflect.Field;
import net.osmand.data.RotatedTileBox;
import net.osmand.plus.OsmandSettings;
import net.osmand.plus.views.OsmandMapLayer;
import net.osmand.plus.views.RouteLayer;
import net.osmand.plus.views.mapwidgets.RouteInfoWidgetsFactory;
import net.sourceforge.offroad.OsmWindow;
import net.sourceforge.offroad.R;
import net.sourceforge.offroad.ui.DirectOffroadLayer;
import net.sourceforge.offroad.ui.OsmBitmapPanel;

public class MapInfoLayer
extends OsmandMapLayer
implements DirectOffroadLayer {
    private final OsmBitmapPanel map;
    private final RouteLayer routeLayer;
    private OsmBitmapPanel view;
    private RouteInfoWidgetsFactory.RulerWidget rulerControl;
    private OsmandSettings settings;
    private OsmandMapLayer.DrawSettings drawSettings;
    private int themeId = -1;

    public MapInfoLayer(OsmBitmapPanel map, RouteLayer layer) {
        this.map = map;
        this.settings = map.getApplication().getSettings();
        this.routeLayer = layer;
    }

    public OsmBitmapPanel getMapActivity() {
        return this.map;
    }

    @Override
    public void initLayer(OsmBitmapPanel view) {
        this.view = view;
        this.registerAllControls();
        this.recreateControls();
    }

    public void registerAllControls() {
        RouteInfoWidgetsFactory ric = new RouteInfoWidgetsFactory();
        OsmWindow app = this.view.getApplication();
        this.rulerControl = new RouteInfoWidgetsFactory.RulerWidget(app, this.map);
    }

    public void recreateControls() {
    }

    public void updateColorShadowsOfText() {
        boolean following;
        boolean nightMode;
        boolean transparent = this.view.getSettings().TRANSPARENT_MAP_THEME.get();
        int calcThemeId = (transparent ? 4 : 0) | ((nightMode = this.drawSettings == null ? false : this.drawSettings.isNightMode()) ? 2 : 0) | ((following = this.routeLayer.getHelper().isFollowingMode()) ? 1 : 0);
        if (this.themeId != calcThemeId) {
            this.themeId = calcThemeId;
            TextState ts = this.calculateTextState();
            this.rulerControl.updateTextSize(nightMode, ts.textColor, ts.textShadowColor, (int)(2.0f * this.view.getDensity()));
        }
    }

    private TextState calculateTextState() {
        boolean transparent = this.view.getSettings().TRANSPARENT_MAP_THEME.get();
        boolean nightMode = this.drawSettings == null ? false : this.drawSettings.isNightMode();
        boolean following = this.routeLayer.getHelper().isFollowingMode();
        TextState ts = new TextState();
        ts.textColor = nightMode ? this.view.getResources().getColor(R.color.widgettext_night) : R.color.color_black.getRGB();
        ts.textShadowColor = nightMode ? this.view.getResources().getColor(R.color.widgettext_shadow_night) : R.color.color_white.getRGB();
        return ts;
    }

    @Override
    public void onDraw(Graphics2D canvas, RotatedTileBox tileBox, OsmandMapLayer.DrawSettings drawSettings) {
        this.drawSettings = drawSettings;
        this.updateColorShadowsOfText();
        this.rulerControl.updateInfo(canvas, tileBox, drawSettings);
    }

    @Override
    public void destroyLayer() {
    }

    @Override
    public boolean drawInScreenPixels() {
        return true;
    }

    public static String getStringPropertyName(OsmWindow ctx, String propertyName, String defValue) {
        try {
            Field f = R.string.class.getField("rendering_attr_" + propertyName + "_name");
            if (f != null) {
                Integer in = (Integer)f.get(null);
                return ctx.getString(in);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return defValue;
    }

    public static String getStringPropertyDescription(OsmWindow ctx, String propertyName, String defValue) {
        try {
            Field f = R.string.class.getField("rendering_attr_" + propertyName + "_description");
            if (f != null) {
                Integer in = (Integer)f.get(null);
                return ctx.getString(in);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return defValue;
    }

    private static class TextState {
        int textColor;
        int textShadowColor;

        private TextState() {
        }
    }
}

