/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.awt.Dialog;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.CharConversionException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.apisupport.project.ModuleDependency;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.NbModuleType;
import org.netbeans.modules.apisupport.project.ProjectXMLManager;
import org.netbeans.modules.apisupport.project.SuiteProvider;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.ActionFilterNode;
import org.netbeans.modules.apisupport.project.ui.ApisupportAntUIUtils;
import org.netbeans.modules.apisupport.project.ui.ImportantFilesNodeFactory;
import org.netbeans.modules.apisupport.project.ui.LibrariesSourceGroup;
import org.netbeans.modules.apisupport.project.ui.ModulesNodeFactory;
import org.netbeans.modules.apisupport.project.ui.PlatformNode;
import org.netbeans.modules.apisupport.project.ui.customizer.AddModulePanel;
import org.netbeans.modules.apisupport.project.ui.customizer.ClusterInfo;
import org.netbeans.modules.apisupport.project.ui.customizer.EditDependencyPanel;
import org.netbeans.modules.apisupport.project.ui.customizer.SingleModuleProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.modules.apisupport.project.universe.TestModuleDependency;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.DeleteAction;
import org.openide.actions.FindAction;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.CookieAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.xml.XMLUtil;

final class LibrariesNode
extends AbstractNode {
    private static final Logger LOG = Logger.getLogger(LibrariesNode.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(LibrariesNode.class);
    static final String LIBRARIES_NAME = "libraries";
    private static final String DISPLAY_NAME = LibrariesNode.getMessage("LBL_libraries");
    private final Action[] actions;

    public LibrariesNode(NbModuleProject project) {
        super((Children)new LibrariesChildren(project), Lookups.fixed((Object[])new Object[]{project}));
        this.setName(LIBRARIES_NAME);
        this.setDisplayName(DISPLAY_NAME);
        this.actions = project.getModuleType() == NbModuleType.SUITE_COMPONENT ? new Action[]{new AddModuleDependencyAction(project), new ModulesNodeFactory.AddNewLibraryWrapperAction(project, project)} : new Action[]{new AddModuleDependencyAction(project)};
    }

    public Image getIcon(int type) {
        return this.getIcon(false);
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(true);
    }

    private Image getIcon(boolean opened) {
        Image badge = ImageUtilities.loadImage((String)"org/netbeans/modules/apisupport/project/ui/resources/libraries-badge.png", (boolean)true);
        return ImageUtilities.mergeImages((Image)ApisupportAntUIUtils.getTreeFolderIcon(opened), (Image)badge, (int)8, (int)8);
    }

    public Action[] getActions(boolean context) {
        return this.actions;
    }

    private static String createHtmlDescription(ModuleDependency dep) {
        StringBuilder shortDesc = new StringBuilder("<html><u>" + dep.getModuleEntry().getCodeNameBase() + "</u><br>");
        if (dep.hasImplementationDependency()) {
            shortDesc.append("<br><font color=\"red\">" + LibrariesNode.getMessage("CTL_ImplementationDependency") + "</font>");
        }
        if (dep.hasCompileDependency()) {
            shortDesc.append("<br>").append(LibrariesNode.getMessage("CTL_NeededToCompile"));
        }
        if (dep.getReleaseVersion() != null) {
            shortDesc.append("<br>").append(NbBundle.getMessage(LibrariesNode.class, (String)"CTL_MajorReleaseVersion", (Object)dep.getReleaseVersion()));
        }
        if (dep.getSpecificationVersion() != null) {
            shortDesc.append("<br>").append(NbBundle.getMessage(LibrariesNode.class, (String)"CTL_SpecificationVersion", (Object)dep.getSpecificationVersion()));
        }
        shortDesc.append("</html>");
        return shortDesc.toString();
    }

    private static String getMessage(String bundleKey) {
        return NbBundle.getMessage(LibrariesNode.class, (String)bundleKey);
    }

    private static void removeDependency(NbModuleProject project, ModuleDependency dep) throws IOException {
        new ProjectXMLManager(project).removeDependencies(Collections.singleton(dep));
        ProjectManager.getDefault().saveProject((Project)project);
    }

    private static final class RemoveAction
    extends DeleteAction {
        private RemoveAction() {
        }

        public String getName() {
            return LibrariesNode.getMessage("CTL_RemoveDependency");
        }

        protected void initialize() {
            super.initialize();
            this.putValue("AcceleratorKey", ((DeleteAction)SystemAction.get(DeleteAction.class)).getValue("AcceleratorKey"));
        }
    }

    static final class OpenProjectAction
    extends CookieAction {
        OpenProjectAction() {
        }

        protected void performAction(Node[] activatedNodes) {
            block6: {
                try {
                    final Project[] projects = new Project[activatedNodes.length];
                    for (int i = 0; i < activatedNodes.length; ++i) {
                        ModuleEntry me = (ModuleEntry)activatedNodes[i].getLookup().lookup(ModuleEntry.class);
                        assert (me != null);
                        File prjDir = me.getSourceLocation();
                        assert (prjDir != null);
                        Project project = ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)prjDir));
                        assert (project != null);
                        projects[i] = project;
                    }
                    RP.post(new Runnable(){

                        @Override
                        public void run() {
                            StatusDisplayer.getDefault().setStatusText(LibrariesNode.getMessage("MSG_OpeningProjects"));
                            OpenProjects.getDefault().open(projects, false);
                        }
                    });
                }
                catch (IOException e) {
                    if ($assertionsDisabled) break block6;
                    throw new AssertionError((Object)e);
                }
            }
        }

        public boolean isEnabled() {
            return true;
        }

        public String getName() {
            return LibrariesNode.getMessage("CTL_Open");
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        protected boolean asynchronous() {
            return false;
        }

        protected int mode() {
            return 4;
        }

        protected Class[] cookieClasses() {
            return new Class[]{ModuleDependency.class, TestModuleDependency.class};
        }
    }

    private static final class ShowJavadocAction
    extends AbstractAction {
        private final ModuleDependency dep;
        private final NbModuleProject project;
        private URL currectJavadoc;

        ShowJavadocAction(ModuleDependency dep, NbModuleProject project) {
            super(LibrariesNode.getMessage("CTL_ShowJavadoc"));
            this.dep = dep;
            this.project = project;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(this.currectJavadoc);
        }

        @Override
        public boolean isEnabled() {
            this.currectJavadoc = this.dep.getModuleEntry().getJavadoc(this.project.getPlatform(true));
            return this.currectJavadoc != null;
        }
    }

    private static final class EditDependencyAction
    extends AbstractAction {
        private final NbModuleProject project;
        private final String codeNameBase;

        EditDependencyAction(String codeNameBase, NbModuleProject project) {
            super(LibrariesNode.getMessage("CTL_EditDependency"));
            this.codeNameBase = codeNameBase;
            this.project = project;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent ev) {
            ModuleDependency dep;
            SuiteProvider sp = (SuiteProvider)this.project.getLookup().lookup(SuiteProvider.class);
            if (sp != null) {
                ModuleList.refreshModuleListForRoot(sp.getSuiteDirectory());
            }
            final ProjectXMLManager pxm = new ProjectXMLManager(this.project);
            try {
                dep = pxm.getModuleDependency(this.codeNameBase);
            }
            catch (IOException e) {
                LOG.log(Level.INFO, "Cannot get dependencies for module: " + this.codeNameBase, e);
                return;
            }
            NbPlatform plaf = this.project.getPlatform(true);
            EditDependencyPanel editPanel = new EditDependencyPanel(dep, plaf);
            DialogDescriptor descriptor = new DialogDescriptor((Object)editPanel, NbBundle.getMessage(LibrariesNode.class, (String)"CTL_EditModuleDependencyTitle", (Object)dep.getModuleEntry().getLocalizedName()));
            descriptor.setHelpCtx(new HelpCtx("org.netbeans.modules.apisupport.project.ui.customizer.EditDependencyPanel"));
            Dialog d = DialogDisplayer.getDefault().createDialog(descriptor);
            try {
                d.setVisible(true);
                if (descriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
                    final ModuleDependency editedDep = editPanel.getEditedDependency();
                    final AtomicBoolean cancel = new AtomicBoolean();
                    ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                TreeSet<ModuleDependency> deps = new TreeSet<ModuleDependency>(pxm.getDirectDependencies());
                                deps.remove(dep);
                                deps.add(editedDep);
                                if (cancel.get()) {
                                    return;
                                }
                                pxm.replaceDependencies(deps);
                                ProjectManager.getDefault().saveProject((Project)project);
                            }
                            catch (IOException e) {
                                LOG.log(Level.INFO, "Cannot store dependency: " + editedDep, e);
                            }
                            catch (ProjectXMLManager.CyclicDependencyException ex) {
                                NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)ex.getLocalizedMessage(), 2);
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                            }
                        }
                    }, (String)NbBundle.getMessage(LibrariesNode.class, (String)"LibrariesNode.update_deps"), (AtomicBoolean)cancel, (boolean)false);
                }
            }
            finally {
                d.dispose();
            }
        }
    }

    private static final class AddModuleDependencyAction
    extends AbstractAction {
        private final NbModuleProject project;

        AddModuleDependencyAction(NbModuleProject project) {
            super(LibrariesNode.getMessage("CTL_AddModuleDependency"));
            this.project = project;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            FileObject suiteDirectoryFO;
            File suiteDirectory;
            SingleModuleProperties props = SingleModuleProperties.getInstance(this.project);
            final ModuleDependency[] newDeps = AddModulePanel.selectDependencies(props);
            AtomicBoolean cancel = new AtomicBoolean();
            final HashSet<ModuleDependency> dependencies = new HashSet<ModuleDependency>(Arrays.asList(newDeps));
            if (this.project.getModuleType() == NbModuleType.SUITE_COMPONENT && (suiteDirectory = ((SuiteProvider)this.project.getLookup().lookup(SuiteProvider.class)).getSuiteDirectory()) != null && (suiteDirectoryFO = FileUtil.toFileObject((File)suiteDirectory)) != null) {
                try {
                    final Project suiteProject = ProjectManager.getDefault().findProject(suiteDirectoryFO);
                    if (suiteProject != null) {
                        Set<NbModuleProject> subModules = SuiteUtils.getSubProjects(suiteProject);
                        final SuiteProperties suiteProps = new SuiteProperties((SuiteProject)suiteProject, ((SuiteProject)suiteProject).getHelper(), ((SuiteProject)suiteProject).getEvaluator(), subModules);
                        TreeSet<String> includedClusters = null;
                        Set<ClusterInfo> clusterInfoSet = suiteProps.getClusterPath();
                        if (clusterInfoSet != null) {
                            includedClusters = new TreeSet<String>();
                            for (ClusterInfo infoIter : clusterInfoSet) {
                                File clusterDirectory = infoIter.getClusterDir();
                                if (clusterDirectory == null) continue;
                                includedClusters.add(clusterDirectory.getName());
                            }
                        }
                        HashSet<String> disabledModules = new HashSet<String>(Arrays.asList(suiteProps.getDisabledModules()));
                        HashSet<ModuleDependency> dependenciesToIter = new HashSet<ModuleDependency>(Arrays.asList(newDeps));
                        ArrayList<ClusterInfo> updatedClusterPath = null;
                        boolean changed = false;
                        for (ModuleDependency moduleDepIter : dependenciesToIter) {
                            NotifyDescriptor.Confirmation confirmation;
                            if (disabledModules.contains(moduleDepIter.getModuleEntry().getCodeNameBase())) {
                                confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(LibrariesNode.class, (String)"MSG_AddModuelToTargetPlatform", (Object)moduleDepIter.getModuleEntry().getLocalizedName()), NbBundle.getMessage(LibrariesNode.class, (String)"MSG_AddModuelToTargetPlatformTitle"), 0);
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                                if (confirmation.getValue() == NotifyDescriptor.YES_OPTION) {
                                    disabledModules.remove(moduleDepIter.getModuleEntry().getCodeNameBase());
                                    changed = true;
                                    continue;
                                }
                                dependencies.remove(moduleDepIter);
                                continue;
                            }
                            if (includedClusters == null || includedClusters.contains(moduleDepIter.getModuleEntry().getClusterDirectory().getName())) continue;
                            if (suiteProps.getActivePlatform() != null) {
                                confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(LibrariesNode.class, (String)"MSG_AddModuelToTargetPlatformWithItsCluster", (Object)moduleDepIter.getModuleEntry().getLocalizedName(), (Object)moduleDepIter.getModuleEntry().getClusterDirectory().getName()), NbBundle.getMessage(LibrariesNode.class, (String)"MSG_AddModuelToTargetPlatformTitle"), 0);
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                                if (confirmation.getValue() == NotifyDescriptor.YES_OPTION) {
                                    ClusterInfo newClusterInfo = ClusterInfo.create(moduleDepIter.getModuleEntry().getClusterDirectory(), true, true);
                                    if (updatedClusterPath == null) {
                                        updatedClusterPath = new ArrayList<ClusterInfo>();
                                        updatedClusterPath.addAll(suiteProps.getClusterPath());
                                    }
                                    updatedClusterPath.add(newClusterInfo);
                                    Set<ModuleEntry> moduleList = suiteProps.getActivePlatform().getModules();
                                    TreeSet<String> disabledClusterDependencies = new TreeSet<String>();
                                    for (ModuleEntry entryIter : moduleList) {
                                        if (!entryIter.getClusterDirectory().equals(moduleDepIter.getModuleEntry().getClusterDirectory())) continue;
                                        disabledClusterDependencies.add(entryIter.getCodeNameBase());
                                    }
                                    disabledClusterDependencies.remove(moduleDepIter.getModuleEntry().getCodeNameBase());
                                    disabledModules.addAll(disabledClusterDependencies);
                                    changed = true;
                                    continue;
                                }
                                dependencies.remove(moduleDepIter);
                                continue;
                            }
                            dependencies.remove(moduleDepIter);
                        }
                        if (changed) {
                            String[] updatedDiasabledModules = new String[disabledModules.size()];
                            disabledModules.toArray(updatedDiasabledModules);
                            suiteProps.setDisabledModules(updatedDiasabledModules);
                            if (updatedClusterPath != null && updatedClusterPath.size() > 0) {
                                suiteProps.setClusterPath((List<ClusterInfo>)updatedClusterPath);
                            }
                            ProjectManager.mutex().writeAccess(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        suiteProps.storeProperties();
                                        ProjectManager.getDefault().saveProject(suiteProject);
                                    }
                                    catch (IOException ex) {
                                        Exceptions.printStackTrace((Throwable)ex);
                                    }
                                }
                            });
                        }
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IllegalArgumentException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (dependencies.size() > 0) {
                ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ProjectXMLManager pxm = new ProjectXMLManager(project);
                        try {
                            pxm.addDependencies(dependencies);
                            ProjectManager.getDefault().saveProject((Project)project);
                        }
                        catch (IOException e) {
                            LOG.log(Level.INFO, "Cannot add selected dependencies: " + Arrays.asList(newDeps), e);
                        }
                        catch (ProjectXMLManager.CyclicDependencyException ex) {
                            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)ex.getLocalizedMessage(), 2);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                        }
                    }
                }, (String)NbBundle.getMessage(LibrariesNode.class, (String)"LibrariesNode.update_deps"), (AtomicBoolean)cancel, (boolean)false);
            }
        }
    }

    private static final class LibraryDependencyNode
    extends FilterNode {
        private final ModuleDependency dep;
        private final NbModuleProject project;

        LibraryDependencyNode(ModuleDependency dep, NbModuleProject project, Node original) {
            super(original, null, (Lookup)new ProxyLookup(new Lookup[]{original.getLookup(), Lookups.fixed((Object[])new Object[]{dep, project})}));
            this.dep = dep;
            this.project = project;
            this.setShortDescription(LibrariesNode.createHtmlDescription(dep));
        }

        public String getHtmlDisplayName() {
            if (this.dep.getModuleEntry().isDeprecated()) {
                try {
                    return "<s>" + XMLUtil.toElementContent((String)this.getDisplayName()) + "</s>";
                }
                catch (CharConversionException charConversionException) {
                    // empty catch block
                }
            }
            return null;
        }

        public Action[] getActions(boolean context) {
            return new Action[]{new EditDependencyAction(this.dep.getModuleEntry().getCodeNameBase(), this.project), SystemAction.get(FindAction.class), new ShowJavadocAction(this.dep, this.project), SystemAction.get(RemoveAction.class)};
        }

        public Action getPreferredAction() {
            return new EditDependencyAction(this.dep.getModuleEntry().getCodeNameBase(), this.project);
        }

        public boolean canDestroy() {
            return true;
        }

        public void destroy() throws IOException {
            LibrariesNode.removeDependency(this.project, this.dep);
        }
    }

    private static final class ProjectDependencyNode
    extends AbstractNode {
        private final ModuleDependency dep;
        private final NbModuleProject project;

        ProjectDependencyNode(ModuleDependency dep, NbModuleProject project) {
            super(Children.LEAF, Lookups.fixed((Object[])new Object[]{dep, project, dep.getModuleEntry()}));
            this.dep = dep;
            this.project = project;
            ModuleEntry me = dep.getModuleEntry();
            this.setIconBaseWithExtension("org/netbeans/modules/apisupport/project/resources/module.png");
            this.setDisplayName(me.getLocalizedName());
            this.setShortDescription(LibrariesNode.createHtmlDescription(dep));
        }

        public String getHtmlDisplayName() {
            if (this.dep.getModuleEntry().isDeprecated()) {
                try {
                    return "<s>" + XMLUtil.toElementContent((String)this.getDisplayName()) + "</s>";
                }
                catch (CharConversionException charConversionException) {
                    // empty catch block
                }
            }
            return null;
        }

        public Action[] getActions(boolean context) {
            return new Action[]{SystemAction.get(OpenProjectAction.class), new EditDependencyAction(this.dep.getModuleEntry().getCodeNameBase(), this.project), new ShowJavadocAction(this.dep, this.project), SystemAction.get(RemoveAction.class)};
        }

        public Action getPreferredAction() {
            return this.getActions(false)[0];
        }

        public boolean canDestroy() {
            return true;
        }

        public void destroy() throws IOException {
            LibrariesNode.removeDependency(this.project, this.dep);
        }
    }

    private static final class LibrariesChildren
    extends Children.Keys<Object>
    implements AntProjectListener {
        private static final String JDK_PLATFORM_NAME = "jdkPlatform";
        private final NbModuleProject project;
        private ImageIcon librariesIcon;

        LibrariesChildren(NbModuleProject project) {
            this.project = project;
        }

        protected void addNotify() {
            super.addNotify();
            this.project.getHelper().addAntProjectListener((AntProjectListener)this);
            this.refreshKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
            this.project.getHelper().removeAntProjectListener((AntProjectListener)this);
            super.removeNotify();
        }

        private void refreshKeys() {
            ImportantFilesNodeFactory.getNodesSyncRP().post(new Runnable(){

                @Override
                public void run() {
                    try {
                        ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                            public Void run() throws IOException {
                                ProjectXMLManager pxm = new ProjectXMLManager(project);
                                final ArrayList<Object> keys = new ArrayList<Object>();
                                keys.add(LibrariesChildren.JDK_PLATFORM_NAME);
                                TreeSet<String> binOrigs = new TreeSet<String>();
                                binOrigs.addAll(Arrays.asList(pxm.getBinaryOrigins()));
                                keys.addAll(binOrigs);
                                TreeSet<ModuleDependency> deps = new TreeSet<ModuleDependency>(ModuleDependency.LOCALIZED_NAME_COMPARATOR);
                                deps.addAll(pxm.getDirectDependencies());
                                keys.addAll(deps);
                                ImportantFilesNodeFactory.getNodesSyncRP().post(new Runnable(){

                                    @Override
                                    public void run() {
                                        this.setKeys(Collections.unmodifiableList(keys));
                                    }
                                });
                                return null;
                            }
                        });
                    }
                    catch (MutexException e) {
                        LOG.log(Level.FINE, null, e);
                    }
                }
            });
        }

        protected Node[] createNodes(Object key) {
            ArrayList<Object> nodes = new ArrayList<Object>(2);
            if (key == JDK_PLATFORM_NAME) {
                nodes.add(PlatformNode.create(this.project, this.project.evaluator(), "nbjdk.home"));
            } else if (key instanceof ModuleDependency) {
                ModuleDependency dep = (ModuleDependency)key;
                ModuleEntry me = dep.getModuleEntry();
                File srcF = me.getSourceLocation();
                if (srcF == null) {
                    File jarF = me.getJarLocation();
                    URL jarRootURL = FileUtil.urlForArchiveOrDir((File)jarF);
                    assert (jarRootURL != null);
                    FileObject root = URLMapper.findFileObject((URL)jarRootURL);
                    if (root != null) {
                        String name = me.getLocalizedName() + " - " + me.getCodeNameBase();
                        Icon icon = this.getLibrariesIcon();
                        ActionFilterNode pvNode = ActionFilterNode.create(PackageView.createPackageView((SourceGroup)new LibrariesSourceGroup(root, name, icon, icon)));
                        nodes.add((Object)new LibraryDependencyNode(dep, this.project, (Node)pvNode));
                    } else {
                        AbstractNode n = new AbstractNode(Children.LEAF);
                        n.setName(me.getCodeNameBase());
                        nodes.add(n);
                    }
                    for (String cpext : me.getClassPathExtensions().split(File.pathSeparator)) {
                        FileObject jar;
                        if (cpext.length() <= 0 || (jar = FileUtil.toFileObject((File)new File(cpext))) == null) continue;
                        nodes.add(this.createLibraryPackageViewNode(jar));
                    }
                } else {
                    nodes.add((Object)new ProjectDependencyNode(dep, this.project));
                }
            } else {
                FileObject jar = this.project.getHelper().resolveFileObject((String)key);
                if (jar != null) {
                    nodes.add(this.createLibraryPackageViewNode(jar));
                }
            }
            return nodes.toArray(new Node[nodes.size()]);
        }

        private Node createLibraryPackageViewNode(FileObject jfo) {
            Icon icon = this.getLibrariesIcon();
            FileObject root = FileUtil.getArchiveRoot((FileObject)jfo);
            if (root == null) {
                return Node.EMPTY;
            }
            String name = String.format(LibrariesNode.getMessage("LBL_WrappedLibraryFmt"), FileUtil.toFile((FileObject)jfo).getName());
            return ActionFilterNode.create(PackageView.createPackageView((SourceGroup)new LibrariesSourceGroup(root, name, icon, icon)));
        }

        public void configurationXmlChanged(AntProjectEvent ev) {
            if (!this.project.isRunInAtomicAction() && this.project.getHelper().resolveFileObject("nbproject/project.xml") != null) {
                this.refreshKeys();
            }
        }

        public void propertiesChanged(AntProjectEvent ev) {
        }

        private Icon getLibrariesIcon() {
            if (this.librariesIcon == null) {
                this.librariesIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/apisupport/project/api/libraries.gif", (boolean)true);
            }
            return this.librariesIcon;
        }
    }
}

