/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.selenium2.webclient.mocha;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.selenium2.webclient.mocha.Bundle;
import org.netbeans.modules.selenium2.webclient.mocha.preferences.MochaJSPreferences;
import org.netbeans.modules.selenium2.webclient.mocha.preferences.MochaPreferencesValidator;
import org.netbeans.modules.selenium2.webclient.mocha.preferences.MochaSeleniumPreferences;
import org.netbeans.modules.web.common.api.ValidationResult;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public final class CustomizerMocha
extends JPanel {
    private final Project project;
    private final boolean isSelenium;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final SpinnerNumberModel timeoutModel;
    private boolean autoDiscovered = false;
    private volatile String mochaInstallFolder;
    private volatile int timeout;
    private ValidationResult validationResult;
    private JCheckBox autowatchCheckBox;
    private JButton mochaDirBrowseButton;
    private JLabel mochaDirInfoLabel;
    private JLabel mochaDirLabel;
    private JTextField mochaDirTextField;
    private JLabel timeoutInfoLabel;
    private JLabel timeoutLabel;
    private JSpinner timeoutSpinner;

    public CustomizerMocha(Project project, boolean isSelenium) {
        assert (EventQueue.isDispatchThread());
        assert (project != null);
        this.project = project;
        this.isSelenium = isSelenium;
        this.timeoutModel = new SpinnerNumberModel(65534, 1, 65534, 1);
        this.initComponents();
        this.init();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public String getMochaInstallFolder() {
        return this.mochaInstallFolder;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean getAutoWatch() {
        return this.autowatchCheckBox.isSelected();
    }

    public String getWarningMessage() {
        assert (EventQueue.isDispatchThread());
        Iterator iterator = this.validationResult.getWarnings().iterator();
        if (iterator.hasNext()) {
            ValidationResult.Message message = (ValidationResult.Message)iterator.next();
            return message.getMessage();
        }
        return null;
    }

    public String getErrorMessage() {
        assert (EventQueue.isDispatchThread());
        Iterator iterator = this.validationResult.getErrors().iterator();
        if (iterator.hasNext()) {
            ValidationResult.Message message = (ValidationResult.Message)iterator.next();
            return message.getMessage();
        }
        return null;
    }

    private void init() {
        String dir;
        ValidationResult result;
        String mochaDir;
        assert (EventQueue.isDispatchThread());
        String string = mochaDir = this.isSelenium ? MochaSeleniumPreferences.getMochaDir(this.project) : MochaJSPreferences.getMochaDir(this.project);
        if (mochaDir == null) {
            String string2 = mochaDir = this.isSelenium ? MochaJSPreferences.getMochaDir(this.project) : MochaSeleniumPreferences.getMochaDir(this.project);
        }
        if (mochaDir == null && (result = new MochaPreferencesValidator().validateMochaInstallFolder(dir = new File(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), "node_modules/mocha").getAbsolutePath()).getResult()).isFaultless()) {
            mochaDir = dir;
            this.autoDiscovered = true;
        }
        this.mochaDirTextField.setText(mochaDir);
        this.mochaDirInfoLabel.setText(Bundle.CustomizerMocha_mocha_dir_info());
        this.timeoutSpinner.setModel(this.timeoutModel);
        this.timeout = this.isSelenium ? MochaSeleniumPreferences.getTimeout(this.project) : MochaJSPreferences.getTimeout(this.project);
        this.timeoutModel.setValue(this.timeout);
        this.timeoutInfoLabel.setText(Bundle.CustomizerMocha_timeout_info());
        if (this.isSelenium) {
            this.autowatchCheckBox.setVisible(false);
        } else {
            this.autowatchCheckBox.setSelected(MochaJSPreferences.isAutoWatch(this.project));
        }
        this.addListeners();
        this.validateData();
    }

    private void addListeners() {
        DefaultDocumentListener defaultDocumentListener = new DefaultDocumentListener();
        this.mochaDirTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.timeoutModel.addChangeListener(new DefaultChangeListener());
    }

    void validateData() {
        assert (EventQueue.isDispatchThread());
        this.mochaInstallFolder = this.mochaDirTextField.getText();
        this.validationResult = new MochaPreferencesValidator().validateMochaInstallFolder(this.mochaInstallFolder).getResult();
        if (this.autoDiscovered) {
            this.validationResult.addWarning(new ValidationResult.Message((Object)"path", Bundle.CustomizerMocha_confirm_autodiscovered_info()));
        }
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.mochaDirLabel = new JLabel();
        this.mochaDirTextField = new JTextField();
        this.mochaDirBrowseButton = new JButton();
        this.mochaDirInfoLabel = new JLabel();
        this.timeoutLabel = new JLabel();
        this.timeoutInfoLabel = new JLabel();
        this.timeoutSpinner = new JSpinner();
        this.autowatchCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((JLabel)this.mochaDirLabel, (String)NbBundle.getMessage(CustomizerMocha.class, (String)"CustomizerMocha.mochaDirLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.mochaDirBrowseButton, (String)NbBundle.getMessage(CustomizerMocha.class, (String)"CustomizerMocha.mochaDirBrowseButton.text"));
        this.mochaDirBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerMocha.this.mochaDirBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.mochaDirInfoLabel, (String)NbBundle.getMessage(CustomizerMocha.class, (String)"CustomizerMocha.mochaDirInfoLabel.text"));
        this.timeoutLabel.setLabelFor(this.timeoutSpinner);
        Mnemonics.setLocalizedText((JLabel)this.timeoutLabel, (String)NbBundle.getMessage(CustomizerMocha.class, (String)"CustomizerMocha.timeoutLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.timeoutInfoLabel, (String)NbBundle.getMessage(CustomizerMocha.class, (String)"CustomizerMocha.timeoutInfoLabel.text"));
        this.timeoutSpinner.setEditor(new JSpinner.NumberEditor(this.timeoutSpinner, "#"));
        Mnemonics.setLocalizedText((AbstractButton)this.autowatchCheckBox, (String)NbBundle.getMessage(CustomizerMocha.class, (String)"CustomizerMocha.autowatchCheckBox.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mochaDirLabel).addComponent(this.timeoutLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.mochaDirTextField, -1, 237, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mochaDirBrowseButton).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mochaDirInfoLabel).addComponent(this.timeoutInfoLabel).addComponent(this.timeoutSpinner, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)))).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.autowatchCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mochaDirLabel).addComponent(this.mochaDirTextField, -2, -1, -2).addComponent(this.mochaDirBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mochaDirInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.timeoutLabel).addComponent(this.timeoutSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.timeoutInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autowatchCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void mochaDirBrowseButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        File file = new FileChooserBuilder(CustomizerMocha.class).setTitle(Bundle.CustomizerMocha_chooser_config()).setDirectoriesOnly(true).setDefaultWorkingDirectory(FileUtil.toFile((FileObject)this.project.getProjectDirectory())).forceUseOfDefaultWorkingDirectory(true).showOpenDialog();
        if (file != null) {
            this.mochaDirTextField.setText(file.getAbsolutePath());
        }
    }

    private final class DefaultChangeListener
    implements ChangeListener {
        private DefaultChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            CustomizerMocha.this.timeout = CustomizerMocha.this.timeoutModel.getNumber().intValue();
            CustomizerMocha.this.validateData();
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processChange();
        }

        private void processChange() {
            CustomizerMocha.this.validateData();
        }
    }
}

