/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual;

import java.util.Collections;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.css.visual.Bundle;
import org.netbeans.modules.css.visual.DocumentViewModel;
import org.netbeans.modules.css.visual.Filter;
import org.netbeans.modules.css.visual.StyleSheetNode;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class DocumentNode
extends AbstractNode {
    private static final RequestProcessor RP = new RequestProcessor(DocumentNode.class);
    static final String ICON_BASE = "org/netbeans/modules/css/visual/resources/style_sheet_16.png";

    DocumentNode(DocumentViewModel pageModel, Filter filter) {
        super((Children)new DocumentChildren(pageModel, filter), (Lookup)new DocumentLookup());
        this.setDisplayName(Bundle.DocumentNode_displayName());
        this.setIconBaseWithExtension(ICON_BASE);
        this.updateLookup(pageModel);
    }

    void setModel(DocumentViewModel model) {
        Node[] nodes;
        DocumentChildren children = (DocumentChildren)this.getChildren();
        children.setModel(model);
        for (Node node : nodes = this.getChildren().getNodes(true)) {
            StyleSheetNode sn = (StyleSheetNode)node;
            StyleSheetNode.StyleSheetChildren snChildren = (StyleSheetNode.StyleSheetChildren)sn.getChildren();
            snChildren.setModel(model);
        }
        this.updateLookup(model);
    }

    private void updateLookup(DocumentViewModel model) {
        DocumentLookup lookup = (DocumentLookup)this.getLookup();
        lookup.update(model);
    }

    static class DocumentChildren
    extends Children.Keys<FileObject>
    implements ChangeListener {
        private static boolean first_run = true;
        private final Filter filter;
        private DocumentViewModel model;
        private final UserTask refreshKeysTask;

        private DocumentChildren(DocumentViewModel model, Filter filter) {
            this.model = model;
            this.filter = filter;
            this.refreshKeysTask = new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    DocumentChildren.this.refreshKeysImpl();
                }
            };
        }

        private void setModel(DocumentViewModel newModel) {
            if (this.model != null) {
                this.model.removeChangeListener(this);
            }
            this.model = newModel;
            if (this.model != null) {
                this.model.addChangeListener(this);
            }
            this.refreshKeys();
        }

        private void refreshKeys() {
            try {
                if (first_run) {
                    first_run = false;
                    ParserManager.parseWhenScanFinished((String)"text/css", (UserTask)this.refreshKeysTask);
                } else {
                    ParserManager.parse((String)"text/css", (UserTask)this.refreshKeysTask);
                }
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        private void refreshKeysImpl() {
            final List keys = this.model != null ? this.model.getFilesToRulesMap().keySet() : Collections.emptyList();
            RP.post(new Runnable(){

                @Override
                public void run() {
                    DocumentChildren.this.setKeys(keys);
                }
            });
        }

        protected Node[] createNodes(FileObject key) {
            return new Node[]{new StyleSheetNode(this.model, key, this.filter)};
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            this.refreshKeys();
        }
    }

    static class DocumentLookup
    extends ProxyLookup {
        DocumentLookup() {
        }

        void update(DocumentViewModel model) {
            FileObject file = null;
            if (model != null) {
                file = model.getFile();
            }
            Project project = null;
            if (file != null) {
                project = FileOwnerQuery.getOwner((FileObject)file);
            }
            if (project == null) {
                this.setLookups(new Lookup[0]);
            } else {
                this.setLookups(new Lookup[]{Lookups.singleton((Object)project)});
            }
        }
    }
}

