/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.axi.visitor;

import java.util.Stack;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIDocument;
import org.netbeans.modules.xml.axi.AnyAttribute;
import org.netbeans.modules.xml.axi.AnyElement;
import org.netbeans.modules.xml.axi.Attribute;
import org.netbeans.modules.xml.axi.Compositor;
import org.netbeans.modules.xml.axi.ContentModel;
import org.netbeans.modules.xml.axi.Element;
import org.netbeans.modules.xml.axi.impl.ElementRef;
import org.netbeans.modules.xml.axi.visitor.DefaultVisitor;

public class DeepAXITreeVisitor
extends DefaultVisitor {
    Stack<AXIComponent> pathToRoot = new Stack();

    @Override
    public void visit(AXIDocument root) {
        this.visitChildren(root);
    }

    @Override
    public void visit(Element element) {
        this.visitChildren(element);
    }

    @Override
    public void visit(AnyElement element) {
        this.visitChildren(element);
    }

    @Override
    public void visit(Attribute attribute) {
        this.visitChildren(attribute);
    }

    @Override
    public void visit(AnyAttribute attribute) {
        this.visitChildren(attribute);
    }

    @Override
    public void visit(Compositor compositor) {
        this.visitChildren(compositor);
    }

    @Override
    public void visit(ContentModel element) {
        this.visitChildren(element);
    }

    protected void visitChildren(AXIComponent component) {
        if (!this.canVisit(component)) {
            return;
        }
        this.pathToRoot.push(component.getOriginal());
        for (AXIComponent child : component.getChildren()) {
            child.accept(this);
        }
        this.pathToRoot.pop();
    }

    protected boolean canVisit(AXIComponent component) {
        ElementRef ref;
        Element e;
        if (this.pathToRoot.contains(component)) {
            return false;
        }
        if (component.getComponentType() == AXIComponent.ComponentType.PROXY) {
            return this.canVisit(component.getOriginal());
        }
        return component.getComponentType() != AXIComponent.ComponentType.REFERENCE || !(component instanceof ElementRef) || !this.pathToRoot.contains(e = (ref = (ElementRef)component).getReferent());
    }
}

