/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.axi;

import java.io.IOException;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.Element;
import org.netbeans.modules.xml.axi.impl.AXIModelImpl;
import org.netbeans.modules.xml.axi.visitor.AXIVisitor;
import org.netbeans.modules.xml.schema.model.All;
import org.netbeans.modules.xml.schema.model.Choice;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.Sequence;

public class Compositor
extends AXIComponent {
    private CompositorType type;
    private String minOccurs;
    private String maxOccurs;
    public static final String PROP_COMPOSITOR = "compositor";
    public static final String PROP_MINOCCURS = "minOccurs";
    public static final String PROP_MAXOCCURS = "maxOccurs";
    public static final String PROP_TYPE = "type";

    Compositor(AXIModel model, CompositorType type) {
        super(model);
        this.type = type;
    }

    Compositor(AXIModel model, SchemaComponent schemaComponent) {
        super(model, schemaComponent);
        if (schemaComponent instanceof Sequence) {
            this.type = CompositorType.SEQUENCE;
        }
        if (schemaComponent instanceof Choice) {
            this.type = CompositorType.CHOICE;
        }
        if (schemaComponent instanceof All) {
            this.type = CompositorType.ALL;
        }
    }

    public Compositor(AXIModel model, AXIComponent sharedComponent) {
        super(model, sharedComponent);
    }

    @Override
    public void accept(AXIVisitor visitor) {
        visitor.visit(this);
    }

    public CompositorType getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setType(CompositorType value) {
        if (this.getModel() == null) {
            return;
        }
        this.getModel().startTransaction();
        try {
            this.firePropertyChangeEvent(PROP_TYPE, (Object)this.getType(), (Object)value);
        }
        catch (Throwable throwable) {
            this.getModel().endTransaction();
            try {
                ((AXIModelImpl)this.getModel()).setForceSync(true);
                this.getModel().sync();
            }
            catch (IOException iOException) {
            }
            finally {
                if (this.getModel() != null) {
                    ((AXIModelImpl)this.getModel()).setForceSync(false);
                }
            }
            throw throwable;
        }
        this.getModel().endTransaction();
        try {
            ((AXIModelImpl)this.getModel()).setForceSync(true);
            this.getModel().sync();
        }
        catch (IOException iOException) {
        }
        finally {
            if (this.getModel() != null) {
                ((AXIModelImpl)this.getModel()).setForceSync(false);
            }
        }
    }

    void setCompositorType(CompositorType newType) {
        this.type = newType;
    }

    public String getMinOccurs() {
        return this.minOccurs;
    }

    public void setMinOccurs(String value) {
        String oldValue = this.getMinOccurs();
        if (oldValue == null && value == null || oldValue != null && oldValue.equals(value)) {
            return;
        }
        this.minOccurs = value;
        this.firePropertyChangeEvent(PROP_MINOCCURS, oldValue, value);
    }

    public String getMaxOccurs() {
        return this.maxOccurs;
    }

    public void setMaxOccurs(String value) {
        String oldValue = this.getMaxOccurs();
        if (oldValue == null && value == null || oldValue != null && oldValue.equals(value)) {
            return;
        }
        this.maxOccurs = value;
        this.firePropertyChangeEvent(PROP_MAXOCCURS, oldValue, value);
    }

    public void addCompositor(Compositor compositor) {
        this.appendChild(PROP_COMPOSITOR, compositor);
    }

    public void removeCompositor(Compositor compositor) {
        this.removeChild(PROP_COMPOSITOR, compositor);
    }

    public void addElement(Element element) {
        this.appendChild("element", element);
    }

    public void removeElement(Element element) {
        this.removeChild("element", element);
    }

    public boolean allowsFullMultiplicity() {
        return !(this.getParent() instanceof Compositor) || ((Compositor)this.getParent()).getType() != CompositorType.ALL;
    }

    public String toString() {
        if (this.type == null) {
            return null;
        }
        return this.type.toString();
    }

    public static enum CompositorType {
        SEQUENCE,
        CHOICE,
        ALL;


        public String getName() {
            return this.toString();
        }

        public String toString() {
            String retValue = super.toString();
            return retValue.substring(0, 1) + retValue.substring(1).toLowerCase();
        }
    }
}

