/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation.graph;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.logging.Logger;
import org.netbeans.api.visual.vmd.VMDColorScheme;
import org.netbeans.api.visual.vmd.VMDNodeWidget;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.web.jsf.navigation.NavigationCaseEdge;
import org.netbeans.modules.web.jsf.navigation.Page;
import org.netbeans.modules.web.jsf.navigation.PageFlowView;
import org.netbeans.modules.web.jsf.navigation.Pin;
import org.netbeans.modules.web.jsf.navigation.graph.PageFlowScene;

public class PFENodeWidget
extends VMDNodeWidget {
    private static final Logger LOG = Logger.getLogger(PFENodeWidget.class.getName());
    private boolean previouslyMaximized = false;
    private final LabelWidget loadingWidget = new LabelWidget(this.getScene(), "Loading...");

    public PFENodeWidget(PageFlowScene scene, VMDColorScheme scheme) {
        super((Scene)scene, scheme);
    }

    public void stateChanged() {
        super.stateChanged();
        if (!this.previouslyMaximized && !this.isMinimized()) {
            this.addLoadingWidget();
            this.runPinSetup();
            this.previouslyMaximized = true;
        }
    }

    private final void addLoadingWidget() {
        this.addChild((Widget)this.loadingWidget);
        this.getScene().validate();
    }

    private final void removeLoadingWidget() {
        this.removeChild((Widget)this.loadingWidget);
        this.getScene().validate();
    }

    private void runPinSetup() {
        LOG.entering(PageFlowView.class.getName(), "runPinSetup");
        PageFlowScene scene = (PageFlowScene)this.getScene();
        Object objPage = scene.findObject((Widget)this);
        if (objPage instanceof Page) {
            final Page page = (Page)objPage;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LOG.finest("    PFE: Inside Thread: " + Calendar.getInstance().getTime());
                    if (!page.isDataNode()) {
                        if (PFENodeWidget.this.getScene() != null) {
                            PFENodeWidget.this.removeLoadingWidget();
                        }
                        return;
                    }
                    Collection<Pin> newPinNodes = page.getPinNodes();
                    LOG.finest("    PFE: Completed Nodes Setup: " + Calendar.getInstance().getTime());
                    LOG.finest("    PFE: Starting Redraw: " + Calendar.getInstance().getTime());
                    PFENodeWidget.this.removeLoadingWidget();
                    PageFlowScene scene = (PageFlowScene)PFENodeWidget.this.getScene();
                    ArrayList redrawCaseNodes = new ArrayList();
                    ArrayList pinNodes = new ArrayList(scene.getPins());
                    for (Pin pin : pinNodes) {
                        if (pin.getPage() != page) continue;
                        Collection caseNodes = scene.findPinEdges(pin, true, false);
                        redrawCaseNodes.addAll(caseNodes);
                        if (pin.isDefault()) continue;
                        scene.removePin(pin);
                    }
                    if (newPinNodes.size() > 0) {
                        for (Pin pinNode : newPinNodes) {
                            scene.addPin(page, pinNode);
                        }
                    }
                    for (NavigationCaseEdge caseNode : redrawCaseNodes) {
                        scene.getPageFlowView().setEdgeSourcePin(caseNode, page);
                    }
                    scene.updateNodeWidgetActions(page);
                    scene.validate();
                    LOG.finest("    PFE: Ending Redraw: " + Calendar.getInstance().getTime());
                }
            });
        }
        LOG.exiting(PageFlowView.class.getName(), "runPinSetup");
    }
}

