/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.gsf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.api.StructureScanner;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.web.core.syntax.gsf.JspParserResult;
import org.netbeans.modules.web.core.syntax.parser.JspSyntaxElement;

public class JspStructureScanner
implements StructureScanner {
    public List<? extends StructureItem> scan(ParserResult info) {
        return Collections.EMPTY_LIST;
    }

    public Map<String, List<OffsetRange>> folds(ParserResult info) {
        JspParserResult jspParserResult = (JspParserResult)info;
        ArrayList<OffsetRange> comments = new ArrayList<OffsetRange>();
        ArrayList<OffsetRange> tags = new ArrayList<OffsetRange>();
        ArrayList<OffsetRange> scriptlets = new ArrayList<OffsetRange>();
        Stack<JspSyntaxElement.OpenTag> openTagsStack = new Stack<JspSyntaxElement.OpenTag>();
        List<JspSyntaxElement> elements = jspParserResult.elements();
        for (JspSyntaxElement element : elements) {
            switch (element.kind()) {
                case COMMENT: {
                    comments.add(new OffsetRange(element.from(), element.to()));
                    break;
                }
                case OPENTAG: {
                    this.handleOpenTagElement((JspSyntaxElement.OpenTag)element, openTagsStack, tags);
                    break;
                }
                case ENDTAG: {
                    this.handleEndTagElement((JspSyntaxElement.EndTag)element, openTagsStack, tags);
                    break;
                }
                case SCRIPTING: {
                    scriptlets.add(new OffsetRange(element.from(), element.to()));
                }
            }
        }
        HashMap<String, List<OffsetRange>> folds = new HashMap<String, List<OffsetRange>>();
        folds.put("tags", tags);
        folds.put("comments", comments);
        folds.put("codeblocks", scriptlets);
        return folds;
    }

    public StructureScanner.Configuration getConfiguration() {
        return null;
    }

    private void handleOpenTagElement(JspSyntaxElement.OpenTag openTag, Stack<JspSyntaxElement.OpenTag> openTagsStack, List<OffsetRange> tags) {
        if (openTag.isEmpty()) {
            tags.add(new OffsetRange(openTag.from(), openTag.to()));
        } else {
            openTagsStack.push(openTag);
        }
    }

    private void handleEndTagElement(JspSyntaxElement.EndTag endTag, Stack<JspSyntaxElement.OpenTag> openTagsStack, List<OffsetRange> tags) {
        if (openTagsStack.isEmpty()) {
            return;
        }
        JspSyntaxElement.OpenTag top = openTagsStack.peek();
        if (endTag.name().equals(top.name())) {
            tags.add(new OffsetRange(top.from(), endTag.to()));
            openTagsStack.pop();
        } else {
            ArrayList<JspSyntaxElement.OpenTag> savedElements = new ArrayList<JspSyntaxElement.OpenTag>();
            boolean foundStartTag = false;
            while (!openTagsStack.isEmpty()) {
                JspSyntaxElement.OpenTag start = openTagsStack.pop();
                savedElements.add(start);
                if (!start.name().equals(endTag.name())) continue;
                tags.add(new OffsetRange(start.from(), endTag.to()));
                foundStartTag = true;
                break;
            }
            if (!foundStartTag) {
                for (int i = savedElements.size() - 1; i >= 0; --i) {
                    openTagsStack.push((JspSyntaxElement.OpenTag)savedElements.get(i));
                }
            }
        }
    }
}

