/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.nbimpl.actions;

import org.netbeans.modules.profiler.api.EditorSupport;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.java.JavaProfilerSource;
import org.netbeans.modules.profiler.api.java.SourceMethodInfo;
import org.netbeans.modules.profiler.nbimpl.actions.Bundle;
import org.netbeans.modules.profiler.v2.ProfilerSession;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;
import org.openide.util.lookup.Lookups;

public final class ProfileMethodEditorAction
extends NodeAction {
    public String getName() {
        return Bundle.ProfileMethodEditorAction_Name();
    }

    protected boolean enable(Node[] activatedNodes) {
        return true;
    }

    protected void performAction(final Node[] nodes) {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                try {
                    DataObject dobj = (DataObject)nodes[0].getLookup().lookup(DataObject.class);
                    if (dobj == null) {
                        return;
                    }
                    JavaProfilerSource src = JavaProfilerSource.createFrom((FileObject)dobj.getPrimaryFile());
                    if (src == null) {
                        return;
                    }
                    int currentOffsetInEditor = EditorSupport.getCurrentOffset();
                    if (currentOffsetInEditor == -1) {
                        return;
                    }
                    SourceMethodInfo resolvedMethod = src.resolveMethodAtPosition(currentOffsetInEditor);
                    if (resolvedMethod == null) {
                        ProfilerDialogs.displayWarning((String)Bundle.ProfileMethodEditorAction_NoMethodFoundAtPosition());
                        return;
                    }
                    if (!resolvedMethod.isExecutable()) {
                        ProfilerDialogs.displayInfo((String)Bundle.ProfileMethodEditorAction_CannotAddAbstractNativeProfilingRoot());
                        return;
                    }
                    Lookup.Provider project = ProjectUtilities.getProject((FileObject)dobj.getPrimaryFile());
                    ProfilerSession.findAndConfigure((Lookup)Lookups.fixed((Object[])new Object[]{resolvedMethod}), (Lookup.Provider)project, (String)ProfileMethodEditorAction.this.getName());
                }
                catch (Exception ex) {
                    ProfilerDialogs.displayWarning((String)Bundle.ProfileMethodEditorAction_ProblemProfilingMethod());
                }
            }
        });
    }

    public HelpCtx getHelpCtx() {
        return null;
    }
}

