/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla;

import org.netbeans.modules.bugtracking.spi.QueryController;
import org.netbeans.modules.bugtracking.spi.QueryProvider;
import org.netbeans.modules.bugzilla.issue.BugzillaIssue;
import org.netbeans.modules.bugzilla.kenai.KenaiRepository;
import org.netbeans.modules.bugzilla.query.BugzillaQuery;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.openide.util.NbBundle;

public class BugzillaQueryProvider
implements QueryProvider<BugzillaQuery, BugzillaIssue> {
    public String getDisplayName(BugzillaQuery query) {
        String name = query.getDisplayName();
        return name != null ? name + (this.needsAndHasNoLogin(query) ? " " + NbBundle.getMessage(BugzillaQueryProvider.class, (String)"LBL_NotLoggedIn") : "") : null;
    }

    public String getTooltip(BugzillaQuery query) {
        return query.getTooltip();
    }

    public QueryController getController(BugzillaQuery query) {
        return query.getController();
    }

    public boolean canRemove(BugzillaQuery q) {
        return q.canRemove();
    }

    public void remove(BugzillaQuery q) {
        q.remove();
    }

    public boolean canRename(BugzillaQuery q) {
        return true;
    }

    public void rename(BugzillaQuery q, String displayName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setIssueContainer(BugzillaQuery query, QueryProvider.IssueContainer<BugzillaIssue> c) {
        query.getController().setContainer(c);
    }

    public void refresh(BugzillaQuery query) {
        if (this.needsAndHasNoLogin(query)) {
            return;
        }
        query.getController().refresh(true);
    }

    private boolean needsAndHasNoLogin(BugzillaQuery query) {
        BugzillaRepository repo = query.getRepository();
        if (repo instanceof KenaiRepository) {
            KenaiRepository kenaiRepo = (KenaiRepository)repo;
            return kenaiRepo.isMyIssues(query) && !kenaiRepo.isLoggedIn();
        }
        return false;
    }
}

