/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee.ui;

import java.awt.Dimension;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import org.openide.util.NbBundle;

public class DebugPortQuery
extends JPanel {
    private JLabel debugPortLable;
    private JSpinner debugPortSpinner;
    private JCheckBox noAskCheck;

    public DebugPortQuery() {
        this.initComponents();
    }

    public void setDebugPort(String debugPort) {
        try {
            int port = Integer.valueOf(debugPort);
            if (port > 0 && port < 65536) {
                this.debugPortSpinner.getModel().setValue(port);
            } else {
                Logger.getLogger("glassfish-javaee").log(Level.INFO, "Debug port out of range in DebugPortQuery");
            }
        }
        catch (NumberFormatException ex) {
            Logger.getLogger("glassfish-javaee").log(Level.INFO, "Invalid debug port, using default = 9009.", ex);
        }
    }

    public String getDebugPort() {
        Object value = this.debugPortSpinner.getModel().getValue();
        return value != null ? value.toString() : "";
    }

    public boolean shouldPersist() {
        return this.noAskCheck.getModel().isSelected();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        preferredSize.height = preferredSize.height * 29 / 25;
        return preferredSize;
    }

    private void initComponents() {
        this.debugPortLable = new JLabel();
        this.debugPortSpinner = new JSpinner();
        this.noAskCheck = new JCheckBox();
        this.debugPortLable.setText(NbBundle.getMessage(DebugPortQuery.class, (String)"DebugPortQuery.debugPortLable.text"));
        this.debugPortLable.setVerticalTextPosition(1);
        this.debugPortSpinner.setModel(new SpinnerNumberModel(9009, 1, 65535, 1));
        this.noAskCheck.setSelected(true);
        this.noAskCheck.setText(NbBundle.getMessage(DebugPortQuery.class, (String)"DebugPortQuery.noAskCheck.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.debugPortLable, GroupLayout.Alignment.TRAILING, -1, 393, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.debugPortSpinner, -2, -1, -2).addGap(204, 204, 204)).addComponent(this.noAskCheck, -1, 393, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.debugPortLable, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.debugPortSpinner, -2, -1, -2).addGap(18, 18, 18).addComponent(this.noAskCheck, -2, -1, -2).addContainerGap()));
    }
}

