/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.util;

import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.security.trust.client.STSIssuedTokenConfiguration;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.opt.impl.util.StreamUtil;
import com.sun.xml.wss.AliasSelector;
import com.sun.xml.wss.SecurityEnvironment;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.ProcessingContextImpl;
import com.sun.xml.wss.impl.WssSoapFaultException;
import com.sun.xml.wss.impl.callback.KeyStoreCallback;
import com.sun.xml.wss.impl.misc.Base64;
import com.sun.xml.wss.jaxws.impl.TubeConfiguration;
import com.sun.xml.wss.logging.LogStringsMessages;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jvnet.staxex.Base64Data;
import org.jvnet.staxex.XMLStreamReaderEx;

public class CertificateRetriever {
    protected TubeConfiguration pipeConfig = null;
    private static Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");
    private String location = null;
    private String password = null;
    private String alias = null;
    private Certificate cs = null;
    private FileInputStream fis = null;
    private Policy ep = null;
    private String callbackHandler = null;
    private String aliasSelector = null;

    public byte[] getBSTFromIdentityExtension(XMLStreamReader reader) throws XMLStreamException {
        boolean isKeyInfo = false;
        boolean isBST = false;
        byte[] bstValue = null;
        while (reader.hasNext()) {
            if (reader.getEventType() == 1) {
                isBST = "BinarySecurityToken".equals(reader.getLocalName()) && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(reader.getNamespaceURI());
                boolean bl = isKeyInfo = "KeyInfo".equals(reader.getLocalName()) && "http://www.w3.org/2000/09/xmldsig#".equals(reader.getNamespaceURI());
                if (isBST || isKeyInfo) {
                    if (isBST) {
                        reader.next();
                    } else if (isKeyInfo) {
                        while (reader.hasNext() && !"X509Certificate".equals(reader.getLocalName())) {
                            reader.next();
                        }
                        reader.next();
                    }
                    if (reader.getEventType() == 4) {
                        CharSequence data;
                        if (reader instanceof XMLStreamReaderEx && (data = ((XMLStreamReaderEx)reader).getPCDATA()) instanceof Base64Data) {
                            Base64Data binaryData = (Base64Data)data;
                            bstValue = binaryData.getExact();
                            return bstValue;
                        }
                        try {
                            bstValue = Base64.decode(StreamUtil.getCV(reader));
                        }
                        catch (Base64DecodingException ex) {
                            log.log(Level.WARNING, LogStringsMessages.WSS_0819_ERROR_GETTING_CERTIFICATE_EPRIDENTITY(), ex);
                        }
                    } else {
                        log.log(Level.WARNING, LogStringsMessages.WSS_0819_ERROR_GETTING_CERTIFICATE_EPRIDENTITY());
                    }
                    return bstValue;
                }
            }
            reader.next();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Certificate getServerKeyStore(WSEndpoint wse) throws IOException, XWSSecurityException {
        QName keyStoreQName = new QName("http://schemas.sun.com/2006/03/wss/server", "KeyStore");
        this.setLocationPasswordAndAlias(keyStoreQName, wse);
        if (this.password == null || this.location == null) {
            if (this.callbackHandler == null) {
                return null;
            }
            this.cs = this.getCertificateUsingCallbackHandler(this.callbackHandler);
            return this.cs;
        }
        if (this.alias == null) {
            this.alias = this.getAliasUsingAliasSelector();
        }
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance("JKS");
            this.fis = new FileInputStream(this.location);
            keyStore.load(this.fis, this.password.toCharArray());
            this.cs = keyStore.getCertificate(this.alias);
            if (this.cs == null) {
                log.log(Level.WARNING, LogStringsMessages.WSS_0821_CERTIFICATE_NOT_FOUND_FOR_ALIAS(this.alias));
            }
        }
        catch (FileNotFoundException ex) {
            log.log(Level.WARNING, LogStringsMessages.WSS_0818_ERROR_PUTTING_CERTIFICATE_EPRIDENTITY(), ex);
            Certificate certificate = null;
            return certificate;
        }
        catch (IOException ex) {
            log.log(Level.WARNING, LogStringsMessages.WSS_0818_ERROR_PUTTING_CERTIFICATE_EPRIDENTITY(), ex);
            Certificate certificate = null;
            return certificate;
        }
        catch (NoSuchAlgorithmException ex) {
            log.log(Level.WARNING, LogStringsMessages.WSS_0818_ERROR_PUTTING_CERTIFICATE_EPRIDENTITY(), ex);
            Certificate certificate = null;
            return certificate;
        }
        catch (CertificateException ex) {
            log.log(Level.WARNING, LogStringsMessages.WSS_0818_ERROR_PUTTING_CERTIFICATE_EPRIDENTITY(), ex);
            Certificate certificate = null;
            return certificate;
        }
        catch (KeyStoreException ex) {
            log.log(Level.WARNING, LogStringsMessages.WSS_0818_ERROR_PUTTING_CERTIFICATE_EPRIDENTITY(), ex);
            Certificate certificate = null;
            return certificate;
        }
        finally {
            keyStore = null;
            this.fis.close();
        }
        return this.cs;
    }

    public X509Certificate constructCertificate(byte[] bstValue) {
        try {
            X509Certificate cert = null;
            CertificateFactory fact = CertificateFactory.getInstance("X.509");
            cert = (X509Certificate)fact.generateCertificate(new ByteArrayInputStream(bstValue));
            return cert;
        }
        catch (CertificateException ex) {
            log.log(Level.SEVERE, "error while constructing the certificate from bst value ", ex);
            throw new RuntimeException(ex);
        }
    }

    public boolean checkforEPRIdentity(WSEndpoint wse, QName eprQName) {
        if (wse.getPort() == null) {
            return true;
        }
        this.getEndpointOROperationalLevelPolicy(wse);
        if (this.ep == null) {
            return false;
        }
        for (AssertionSet assertionSet : this.ep) {
            for (PolicyAssertion pa : assertionSet) {
                if (!pa.getName().equals(eprQName)) continue;
                return true;
            }
        }
        return false;
    }

    private String getAliasUsingAliasSelector() {
        if (this.aliasSelector == null) {
            return null;
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> aliasSelectorClass = null;
        if (loader != null) {
            try {
                aliasSelectorClass = loader.loadClass(this.aliasSelector);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        if (aliasSelectorClass == null) {
            loader = this.getClass().getClassLoader();
            try {
                aliasSelectorClass = loader.loadClass(this.aliasSelector);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        if (aliasSelectorClass == null) {
            return null;
        }
        try {
            AliasSelector as = (AliasSelector)aliasSelectorClass.newInstance();
            String myAlias = as.select(new HashMap());
            if (myAlias == null) {
                log.log(Level.WARNING, LogStringsMessages.WSS_0823_ALIAS_NOTFOUND_FOR_ALIAS_SELECTOR());
            }
            return myAlias;
        }
        catch (InstantiationException ex) {
            log.log(Level.WARNING, LogStringsMessages.WSS_0818_ERROR_PUTTING_CERTIFICATE_EPRIDENTITY(), ex);
            return null;
        }
        catch (IllegalAccessException ex) {
            log.log(Level.WARNING, LogStringsMessages.WSS_0818_ERROR_PUTTING_CERTIFICATE_EPRIDENTITY(), ex);
            return null;
        }
    }

    private X509Certificate getCertificateUsingCallbackHandler(String callbackHandler) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> callbackHandlerClass = null;
        if (loader != null) {
            try {
                callbackHandlerClass = loader.loadClass(callbackHandler);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        if (callbackHandlerClass == null) {
            loader = this.getClass().getClassLoader();
            try {
                callbackHandlerClass = loader.loadClass(callbackHandler);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        if (callbackHandlerClass == null) {
            return null;
        }
        KeyStoreCallback ksc = new KeyStoreCallback();
        Callback[] callbacks = new Callback[]{ksc};
        try {
            CallbackHandler cbh = (CallbackHandler)callbackHandlerClass.newInstance();
            cbh.handle(callbacks);
            X509Certificate cert = null;
            cert = (X509Certificate)(ksc.getKeystore() != null ? ksc.getKeystore().getCertificate(this.alias) : null);
            if (cert == null && this.alias != null) {
                log.log(Level.WARNING, LogStringsMessages.WSS_0821_CERTIFICATE_NOT_FOUND_FOR_ALIAS(this.alias));
            }
            return cert;
        }
        catch (IOException ex) {
            log.log(Level.WARNING, LogStringsMessages.WSS_0818_ERROR_PUTTING_CERTIFICATE_EPRIDENTITY(), ex);
            return null;
        }
        catch (UnsupportedCallbackException ex) {
            log.log(Level.WARNING, LogStringsMessages.WSS_0818_ERROR_PUTTING_CERTIFICATE_EPRIDENTITY(), ex);
            return null;
        }
        catch (InstantiationException ex) {
            log.log(Level.WARNING, LogStringsMessages.WSS_0818_ERROR_PUTTING_CERTIFICATE_EPRIDENTITY(), ex);
            return null;
        }
        catch (IllegalAccessException ex) {
            log.log(Level.WARNING, LogStringsMessages.WSS_0818_ERROR_PUTTING_CERTIFICATE_EPRIDENTITY(), ex);
            return null;
        }
        catch (KeyStoreException ex) {
            log.log(Level.WARNING, LogStringsMessages.WSS_0818_ERROR_PUTTING_CERTIFICATE_EPRIDENTITY(), ex);
            return null;
        }
    }

    private void getEndpointOROperationalLevelPolicy(WSEndpoint wse) {
        block4: {
            PolicyMap pm = wse.getPolicyMap();
            WSDLPort port = wse.getPort();
            QName serviceName = port.getOwner().getName();
            QName portName = port.getName();
            PolicyMapKey endpointKey = PolicyMap.createWsdlEndpointScopeKey(serviceName, portName);
            try {
                this.ep = pm.getEndpointEffectivePolicy(endpointKey);
                if (this.ep != null) break block4;
                for (WSDLBoundOperation wSDLBoundOperation : port.getBinding().getBindingOperations()) {
                    QName operationName = new QName(wSDLBoundOperation.getBoundPortType().getName().getNamespaceURI(), wSDLBoundOperation.getName().getLocalPart());
                    PolicyMapKey operationKey = PolicyMap.createWsdlOperationScopeKey(serviceName, portName, operationName);
                    this.ep = pm.getOperationEffectivePolicy(operationKey);
                    if (this.ep == null) continue;
                    break;
                }
            }
            catch (PolicyException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalArgumentException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private void setLocationPasswordAndAlias(QName qName, WSEndpoint wse) {
        if (wse.getPort() == null) {
            return;
        }
        if (this.ep == null) {
            return;
        }
        for (AssertionSet assertionSet : this.ep) {
            for (PolicyAssertion pa : assertionSet) {
                if (!PolicyUtil.isConfigPolicyAssertion(pa) || !pa.getName().equals(qName)) continue;
                this.password = pa.getAttributeValue(new QName("storepass"));
                this.location = pa.getAttributeValue(new QName("location"));
                this.alias = pa.getAttributeValue(new QName("alias"));
                this.callbackHandler = pa.getAttributeValue(new QName("callbackHandler"));
                this.aliasSelector = pa.getAttributeValue(new QName("aliasSelector"));
                StringBuffer sb = null;
                if (this.location == null) continue;
                sb = new StringBuffer(this.location);
                if (!this.location.startsWith("$WSIT")) continue;
                String path = System.getProperty("WSIT_HOME");
                sb.replace(0, 10, path);
                this.location = sb.toString();
            }
        }
    }

    public boolean setServerCertInTheContext(ProcessingContextImpl ctx, SecurityEnvironment secEnv, X509Certificate serverCert) {
        boolean valid = false;
        try {
            valid = secEnv.validateCertificate(serverCert, ctx.getExtraneousProperties());
        }
        catch (WssSoapFaultException ex) {
        }
        catch (XWSSecurityException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0820_ERROR_VALIDATE_CERTIFICATE_EPRIDENTITY(), ex);
        }
        if (valid) {
            log.log(Level.INFO, LogStringsMessages.WSS_0824_USING_SERVER_CERTIFICATE_FROM_EPR_IDENTITY());
            ctx.getExtraneousProperties().put("server-certificate", serverCert);
        } else {
            log.log(Level.WARNING, LogStringsMessages.WSS_0822_ERROR_VALIDATING_SERVER_CERTIFICATE());
        }
        return valid;
    }

    public boolean setServerCertInTheSTSConfig(STSIssuedTokenConfiguration config, SecurityEnvironment secEnv, X509Certificate serverCert) {
        boolean valid = false;
        try {
            valid = secEnv.validateCertificate(serverCert, config.getOtherOptions());
        }
        catch (WssSoapFaultException ex) {
        }
        catch (XWSSecurityException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0820_ERROR_VALIDATE_CERTIFICATE_EPRIDENTITY(), ex);
        }
        if (valid) {
            log.log(Level.INFO, LogStringsMessages.WSS_0824_USING_SERVER_CERTIFICATE_FROM_EPR_IDENTITY());
            config.getOtherOptions().put("Identity", serverCert);
        } else {
            log.log(Level.WARNING, LogStringsMessages.WSS_0822_ERROR_VALIDATING_SERVER_CERTIFICATE());
        }
        return valid;
    }
}

