/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.optional;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.dd.api.common.InitParam;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Filter;
import org.netbeans.modules.j2ee.dd.api.web.FilterMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.tomcat5.deploy.TomcatManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.xml.sax.SAXException;

public class MonitorSupport {
    private static final Logger LOGGER = Logger.getLogger(MonitorSupport.class.getName());
    public static final String MONITOR_ENABLED_PROPERTY_NAME = "monitor_enabled";
    private static final String MONITOR_MODULE_NAME = "org.netbeans.modules.web.monitor";
    private static ModuleInfo httpMonitorInfo;
    private static ModuleSpy monitorSpy;
    private static Lookup.Result res;
    private static MonitorInfoListener monitorInfoListener;
    private static MonitorLookupListener monitorLookupListener;
    private static final String MONITOR_FILTER_NAME = "HTTPMonitorFilter";
    private static final String MONITOR_FILTER_CLASS = "org.netbeans.modules.web.monitor.server.MonitorFilter";
    private static final String MONITOR_FILTER_PATTERN = "/*";
    private static final String MONITOR_INTERNALPORT_PARAM_NAME = "netbeans.monitor.ide";

    public static void setMonitorFlag(String managerURL, boolean enable) {
        InstanceProperties ip = InstanceProperties.getInstanceProperties((String)managerURL);
        ip.setProperty(MONITOR_ENABLED_PROPERTY_NAME, Boolean.toString(enable));
    }

    public static boolean getMonitorFlag(String managerURL) {
        InstanceProperties ip = InstanceProperties.getInstanceProperties((String)managerURL);
        String prop = ip.getProperty(MONITOR_ENABLED_PROPERTY_NAME);
        return prop == null ? true : Boolean.valueOf(prop);
    }

    public static void setMonitorFlag(TomcatManager tm, boolean enable) {
        MonitorSupport.setMonitorFlag(tm.getUri(), enable);
    }

    public static boolean getMonitorFlag(TomcatManager tm) {
        return MonitorSupport.getMonitorFlag(tm.getUri());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void synchronizeMonitorWithFlag(TomcatManager tm, boolean alsoSetPort) throws IOException, SAXException {
        String url = tm.getUri();
        boolean monitorFlag = MonitorSupport.getMonitorFlag(url);
        boolean monitorModuleAvailable = MonitorSupport.isMonitorEnabled();
        boolean shouldInstall = monitorModuleAvailable && monitorFlag;
        File webXML = MonitorSupport.getDefaultWebXML(tm);
        if (webXML == null) {
            Logger.getLogger(MonitorSupport.class.getName()).log(Level.INFO, null, new Exception(url));
            return;
        }
        WebApp webApp = DDProvider.getDefault().getDDRoot(webXML);
        if (webApp == null) {
            Logger.getLogger(MonitorSupport.class.getName()).log(Level.INFO, null, new Exception(url));
            return;
        }
        boolean needsSave = false;
        if (shouldInstall) {
            MonitorSupport.addMonitorJars(tm);
            boolean result = MonitorSupport.changeFilterMonitor(webApp, true);
            boolean bl = needsSave = needsSave || result;
            if (alsoSetPort) {
                result = MonitorSupport.specifyFilterPortParameter(webApp);
                needsSave = needsSave || result;
            }
        } else {
            boolean result = MonitorSupport.changeFilterMonitor(webApp, false);
            boolean bl = needsSave = needsSave || result;
        }
        if (needsSave) {
            try (FileOutputStream os = new FileOutputStream(webXML);){
                webApp.write((OutputStream)os);
            }
        }
    }

    private static File getDefaultWebXML(TomcatManager tm) {
        File cb = tm.getTomcatProperties().getCatalinaDir();
        File webXML = new File(cb, "conf" + File.separator + "web.xml");
        if (webXML.exists()) {
            return webXML;
        }
        return null;
    }

    private static void addMonitorJars(TomcatManager tm) throws IOException {
        File instDir = tm.getTomcatProperties().getCatalinaHome();
        if (instDir == null) {
            return;
        }
        File libFolder = tm.getTomcatProperties().getMonitorLibFolder();
        MonitorSupport.copyFromIDEInstToDir("modules/ext/org-netbeans-modules-web-httpmonitor.jar", new File(libFolder, "org-netbeans-modules-web-httpmonitor.jar"));
        MonitorSupport.copyFromIDEInstToDir("modules/org-netbeans-modules-schema2beans.jar", new File(libFolder, "org-netbeans-modules-schema2beans.jar"));
    }

    private static boolean changeFilterMonitor(WebApp webApp, boolean full) {
        boolean filterWasChanged;
        block12: {
            block11: {
                filterWasChanged = false;
                if (!full) break block11;
                boolean isFilter = false;
                Filter[] filters = webApp.getFilter();
                for (int i = 0; i < filters.length; ++i) {
                    if (!filters[i].getFilterName().equals(MONITOR_FILTER_NAME)) continue;
                    isFilter = true;
                    break;
                }
                if (!isFilter) {
                    try {
                        Filter filter = (Filter)webApp.createBean("Filter");
                        filter.setFilterName(MONITOR_FILTER_NAME);
                        filter.setFilterClass(MONITOR_FILTER_CLASS);
                        webApp.addFilter(filter);
                        filterWasChanged = true;
                    }
                    catch (ClassNotFoundException filter) {
                        // empty catch block
                    }
                }
                boolean isMapping = false;
                FilterMapping[] maps = webApp.getFilterMapping();
                for (int i = 0; i < maps.length; ++i) {
                    if (!maps[i].getFilterName().equals(MONITOR_FILTER_NAME)) continue;
                    isMapping = true;
                    break;
                }
                if (isMapping) break block12;
                try {
                    FilterMapping filterMapping = (FilterMapping)webApp.createBean("FilterMapping");
                    Object[] dispatcher = new String[]{"REQUEST", "FORWARD", "INCLUDE", "ERROR"};
                    try {
                        filterMapping.setDispatcher((String[])dispatcher);
                    }
                    catch (VersionNotSupportedException ex) {
                        ((BaseBean)filterMapping).createProperty("dispatcher", "Dispatcher", 65840, String.class);
                        ((BaseBean)filterMapping).setValue("Dispatcher", dispatcher);
                    }
                    filterMapping.setFilterName(MONITOR_FILTER_NAME);
                    filterMapping.setUrlPattern(MONITOR_FILTER_PATTERN);
                    webApp.addFilterMapping(filterMapping);
                    filterWasChanged = true;
                }
                catch (ClassNotFoundException classNotFoundException) {}
                break block12;
            }
            FilterMapping[] maps = webApp.getFilterMapping();
            for (int i = 0; i < maps.length; ++i) {
                if (!maps[i].getFilterName().equals(MONITOR_FILTER_NAME)) continue;
                webApp.removeFilterMapping(maps[i]);
                filterWasChanged = true;
                break;
            }
            Filter[] filters = webApp.getFilter();
            for (int i = 0; i < filters.length; ++i) {
                if (!filters[i].getFilterName().equals(MONITOR_FILTER_NAME)) continue;
                webApp.removeFilter(filters[i]);
                filterWasChanged = true;
                break;
            }
        }
        return filterWasChanged;
    }

    private static File findInstallationFile(String instRelPath) {
        return InstalledFileLocator.getDefault().locate(instRelPath, null, false);
    }

    private static void copyFromIDEInstToDir(String sourceRelPath, File targetFile) throws IOException {
        File sourceFile = MonitorSupport.findInstallationFile(sourceRelPath);
        if (sourceFile != null && sourceFile.exists() && (!targetFile.exists() || sourceFile.length() != targetFile.length())) {
            MonitorSupport.copy(sourceFile, targetFile);
        }
    }

    private static void copy(File file1, File file2) throws IOException {
        int b;
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file1));
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file2));
        while ((b = bis.read()) != -1) {
            bos.write(b);
        }
        bis.close();
        bos.close();
    }

    private static boolean specifyFilterPortParameter(WebApp webApp) {
        Filter[] filters = webApp.getFilter();
        Filter myFilter = null;
        for (int i = 0; i < filters.length; ++i) {
            if (!MONITOR_FILTER_NAME.equals(filters[i].getFilterName())) continue;
            myFilter = filters[i];
            break;
        }
        if (myFilter == null) {
            return false;
        }
        InitParam[] params = myFilter.getInitParam();
        InitParam myParam = null;
        for (int i = 0; i < params.length; ++i) {
            if (!MONITOR_INTERNALPORT_PARAM_NAME.equals(params[i].getParamName())) continue;
            myParam = params[i];
            break;
        }
        String correctParamValue = MonitorSupport.getLocalHost() + ":" + MonitorSupport.getInternalServerPort();
        if (myParam == null) {
            try {
                InitParam init = (InitParam)myFilter.createBean("InitParam");
                init.setParamName(MONITOR_INTERNALPORT_PARAM_NAME);
                init.setParamValue(correctParamValue);
                myFilter.addInitParam(init);
            }
            catch (ClassNotFoundException ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
            return true;
        }
        if (correctParamValue.equals(myParam.getParamValue())) {
            return false;
        }
        myParam.setParamValue(correctParamValue);
        return true;
    }

    public static String getLocalHost() {
        return "127.0.0.1";
    }

    private static URL getSampleHTTPServerURL() {
        FileObject fo = FileUtil.getConfigFile((String)"HTTPServer_DUMMY");
        if (fo == null) {
            return null;
        }
        URL u = URLMapper.findURL((FileObject)fo, (int)2);
        return u;
    }

    private static String getInternalServerPort() {
        URL u = MonitorSupport.getSampleHTTPServerURL();
        if (u != null) {
            return "" + u.getPort();
        }
        return "8082";
    }

    private static void startModuleSpy(ModuleSpy spy) {
        res = Lookup.getDefault().lookup(new Lookup.Template(ModuleInfo.class));
        Iterator it = res.allInstances().iterator();
        String moduleId = spy.getModuleId();
        boolean found = false;
        while (it.hasNext()) {
            ModuleInfo mi = (ModuleInfo)it.next();
            if (!mi.getCodeName().startsWith(moduleId)) continue;
            httpMonitorInfo = mi;
            spy.setEnabled(mi.isEnabled());
            monitorInfoListener = new MonitorInfoListener(spy);
            httpMonitorInfo.addPropertyChangeListener((PropertyChangeListener)monitorInfoListener);
            found = true;
            break;
        }
        monitorLookupListener = new MonitorLookupListener(spy, httpMonitorInfo);
        res.addLookupListener((LookupListener)monitorLookupListener);
    }

    static synchronized boolean isMonitorEnabled() {
        if (monitorSpy == null) {
            monitorSpy = new ModuleSpy(MONITOR_MODULE_NAME);
            MonitorSupport.startModuleSpy(monitorSpy);
        }
        return monitorSpy.isEnabled();
    }

    void removeListeners() {
        if (httpMonitorInfo != null) {
            httpMonitorInfo.removePropertyChangeListener((PropertyChangeListener)monitorInfoListener);
        }
        if (res != null) {
            res.removeLookupListener((LookupListener)monitorLookupListener);
        }
    }

    private static class MonitorLookupListener
    implements LookupListener {
        ModuleSpy spy;
        ModuleInfo httpMonitorInfo;

        MonitorLookupListener(ModuleSpy spy, ModuleInfo httpMonitorInfo) {
            this.spy = spy;
            this.httpMonitorInfo = httpMonitorInfo;
        }

        public void resultChanged(LookupEvent lookupEvent) {
            Iterator it = res.allInstances().iterator();
            boolean moduleFound = false;
            while (it.hasNext()) {
                ModuleInfo mi = (ModuleInfo)it.next();
                if (!mi.getCodeName().startsWith(this.spy.getModuleId())) continue;
                this.spy.setEnabled(mi.isEnabled());
                if (this.httpMonitorInfo == null) {
                    this.httpMonitorInfo = mi;
                    monitorInfoListener = new MonitorInfoListener(this.spy);
                    this.httpMonitorInfo.addPropertyChangeListener((PropertyChangeListener)monitorInfoListener);
                }
                moduleFound = true;
                break;
            }
            if (!moduleFound && this.httpMonitorInfo != null) {
                this.httpMonitorInfo.removePropertyChangeListener((PropertyChangeListener)monitorInfoListener);
                this.httpMonitorInfo = null;
                this.spy.setEnabled(false);
            }
        }
    }

    private static class MonitorInfoListener
    implements PropertyChangeListener {
        ModuleSpy spy;

        MonitorInfoListener(ModuleSpy spy) {
            this.spy = spy;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("enabled")) {
                this.spy.setEnabled((Boolean)evt.getNewValue());
            }
        }
    }

    private static class ModuleSpy {
        private boolean enabled;
        private String moduleId;

        public ModuleSpy(String moduleId) {
            this.moduleId = moduleId;
        }

        public void setModuleId(String moduleId) {
            this.moduleId = moduleId;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getModuleId() {
            return this.moduleId;
        }
    }
}

