/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.IOException;
import java.util.Collections;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.j2ee.core.api.support.java.SourceUtils;

public class TagHandlerGenerator {
    private Object[][] attributes;
    private JavaSource clazz;
    private boolean isBodyTag;
    private boolean evaluateBody;

    public TagHandlerGenerator(JavaSource clazz, Object[][] attributes, boolean isBodyTag, boolean evaluateBody) {
        this.clazz = clazz;
        this.attributes = attributes;
        this.isBodyTag = isBodyTag;
        this.evaluateBody = evaluateBody;
    }

    public void generate() throws IOException {
        Task<WorkingCopy> task = new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws Exception {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                TreeMaker make = workingCopy.getTreeMaker();
                GenerationUtils gu = GenerationUtils.newInstance((WorkingCopy)workingCopy);
                TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)workingCopy);
                ClassTree oldClassTree = workingCopy.getTrees().getTree(typeElement);
                ClassTree classTree = TagHandlerGenerator.this.addFields(gu, make, typeElement, oldClassTree);
                if (TagHandlerGenerator.this.isBodyTag) {
                    classTree = make.addClassMember(classTree, (Tree)TagHandlerGenerator.this.addBodyEvaluatorCheck(TagHandlerGenerator.this.evaluateBody, make));
                }
                classTree = TagHandlerGenerator.this.addSetters(gu, make, typeElement, classTree);
                workingCopy.rewrite((Tree)oldClassTree, (Tree)classTree);
            }
        };
        ModificationResult result = this.clazz.runModificationTask((Task)task);
        result.commit();
    }

    private ClassTree addFields(GenerationUtils gu, TreeMaker make, TypeElement typeElement, ClassTree classTree) throws IOException {
        for (int i = 0; i < this.attributes.length; ++i) {
            VariableTree field = gu.createField(typeElement, gu.createModifiers(Modifier.PRIVATE), (String)this.attributes[i][0], (String)this.attributes[i][1], null);
            classTree = make.insertClassMember(classTree, i, (Tree)field);
        }
        return classTree;
    }

    private ClassTree addSetters(GenerationUtils gu, TreeMaker make, TypeElement typeElement, ClassTree newClassTree) throws IOException {
        for (int i = 0; i < this.attributes.length; ++i) {
            MethodTree setter = gu.createPropertySetterMethod(typeElement, gu.createModifiers(Modifier.PUBLIC), (String)this.attributes[i][0], (String)this.attributes[i][1]);
            newClassTree = make.addClassMember(newClassTree, (Tree)setter);
        }
        return newClassTree;
    }

    private MethodTree addBodyEvaluatorCheck(boolean evaluateBody, TreeMaker make) throws IOException {
        StringBuffer methodBody = new StringBuffer();
        methodBody.append("{");
        methodBody.append("\n        // TODO: code that determines whether the body should be");
        methodBody.append("\n        //       evaluated should be placed here.");
        methodBody.append("\n        //       Called from the doStartTag() method.");
        methodBody.append("\nreturn " + (evaluateBody ? "true;" : "false;"));
        methodBody.append("\n}");
        MethodTree method = make.Method(make.Modifiers(Collections.singleton(Modifier.PRIVATE)), (CharSequence)"theBodyShouldBeEvaluated", (Tree)make.PrimitiveType(TypeKind.BOOLEAN), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), methodBody.toString(), null);
        return method;
    }
}

