/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.atoum.options;

import java.util.List;
import java.util.prefs.Preferences;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.php.api.util.FileUtils;
import org.openide.util.NbPreferences;

public final class AtoumOptions {
    private static final String PREFERENCES_PATH = "atoum";
    private static final AtoumOptions INSTANCE = new AtoumOptions();
    private static final String ATOUM_PATH = "atoum.path";
    private volatile boolean atoumSearched = false;

    private AtoumOptions() {
    }

    public static AtoumOptions getInstance() {
        return INSTANCE;
    }

    @CheckForNull
    public String getAtoumPath() {
        String path = this.getPreferences().get(ATOUM_PATH, null);
        if (path == null && !this.atoumSearched) {
            this.atoumSearched = true;
            List scripts = FileUtils.findFileOnUsersPath((String[])new String[]{"mageekguy.atoum.phar", PREFERENCES_PATH});
            if (!scripts.isEmpty()) {
                path = (String)scripts.get(0);
                this.setAtoumPath(path);
            }
        }
        return path;
    }

    public void setAtoumPath(String path) {
        this.getPreferences().put(ATOUM_PATH, path);
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(AtoumOptions.class).node(PREFERENCES_PATH);
    }
}

