/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.config.ir;

import co.elastic.logstash.api.Codec;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;
import org.logstash.Rubyfier;
import org.logstash.common.SourceWithMetadata;
import org.logstash.config.ir.PipelineIR;
import org.logstash.config.ir.PluginDefinition;
import org.logstash.config.ir.compiler.AbstractFilterDelegatorExt;
import org.logstash.config.ir.compiler.AbstractOutputDelegatorExt;
import org.logstash.config.ir.compiler.ComputeStepSyntaxElement;
import org.logstash.config.ir.compiler.Dataset;
import org.logstash.config.ir.compiler.DatasetCompiler;
import org.logstash.config.ir.compiler.EventCondition;
import org.logstash.config.ir.compiler.RubyIntegration;
import org.logstash.config.ir.compiler.SplitDataset;
import org.logstash.config.ir.graph.IfVertex;
import org.logstash.config.ir.graph.PluginVertex;
import org.logstash.config.ir.graph.Vertex;
import org.logstash.config.ir.imperative.PluginStatement;

public final class CompiledPipeline {
    private static final Logger LOGGER = LogManager.getLogger(CompiledPipeline.class);
    private final EventCondition.Compiler conditionalCompiler = new EventCondition.Compiler();
    private final Collection<IRubyObject> inputs;
    private final Map<String, AbstractFilterDelegatorExt> filters;
    private final Map<String, AbstractOutputDelegatorExt> outputs;
    private final PipelineIR pipelineIR;
    private final RubyIntegration.PluginFactory pluginFactory;

    public CompiledPipeline(PipelineIR pipelineIR, RubyIntegration.PluginFactory pluginFactory) {
        this.pipelineIR = pipelineIR;
        this.pluginFactory = pluginFactory;
        this.inputs = this.setupInputs();
        this.filters = this.setupFilters();
        this.outputs = this.setupOutputs();
    }

    public Collection<AbstractOutputDelegatorExt> outputs() {
        return Collections.unmodifiableCollection(this.outputs.values());
    }

    public Collection<AbstractFilterDelegatorExt> filters() {
        return Collections.unmodifiableCollection(this.filters.values());
    }

    public Collection<IRubyObject> inputs() {
        return Collections.unmodifiableCollection(this.inputs);
    }

    public Dataset buildExecution() {
        return new CompiledExecution().toDataset();
    }

    private Map<String, AbstractOutputDelegatorExt> setupOutputs() {
        List<PluginVertex> outs = this.pipelineIR.getOutputPluginVertices();
        HashMap<String, AbstractOutputDelegatorExt> res = new HashMap<String, AbstractOutputDelegatorExt>(outs.size());
        outs.forEach(v -> {
            PluginDefinition def = v.getPluginDefinition();
            SourceWithMetadata source = v.getSourceWithMetadata();
            res.put(v.getId(), this.pluginFactory.buildOutput(RubyUtil.RUBY.newString(def.getName()), (RubyInteger)RubyUtil.RUBY.newFixnum(source.getLine().intValue()), (RubyInteger)RubyUtil.RUBY.newFixnum(source.getColumn().intValue()), (IRubyObject)this.convertArgs(def), this.convertJavaArgs(def)));
        });
        return res;
    }

    private Map<String, AbstractFilterDelegatorExt> setupFilters() {
        List<PluginVertex> filterPlugins = this.pipelineIR.getFilterPluginVertices();
        HashMap<String, AbstractFilterDelegatorExt> res = new HashMap<String, AbstractFilterDelegatorExt>(filterPlugins.size(), 1.0f);
        for (PluginVertex vertex : filterPlugins) {
            PluginDefinition def = vertex.getPluginDefinition();
            SourceWithMetadata source = vertex.getSourceWithMetadata();
            res.put(vertex.getId(), this.pluginFactory.buildFilter(RubyUtil.RUBY.newString(def.getName()), (RubyInteger)RubyUtil.RUBY.newFixnum(source.getLine().intValue()), (RubyInteger)RubyUtil.RUBY.newFixnum(source.getColumn().intValue()), (IRubyObject)this.convertArgs(def), this.convertJavaArgs(def)));
        }
        return res;
    }

    private Collection<IRubyObject> setupInputs() {
        List<PluginVertex> vertices = this.pipelineIR.getInputPluginVertices();
        HashSet<IRubyObject> nodes = new HashSet<IRubyObject>(vertices.size());
        vertices.forEach(v -> {
            PluginDefinition def = v.getPluginDefinition();
            SourceWithMetadata source = v.getSourceWithMetadata();
            IRubyObject o = this.pluginFactory.buildInput(RubyUtil.RUBY.newString(def.getName()), (RubyInteger)RubyUtil.RUBY.newFixnum(source.getLine().intValue()), (RubyInteger)RubyUtil.RUBY.newFixnum(source.getColumn().intValue()), (IRubyObject)this.convertArgs(def), this.convertJavaArgs(def));
            nodes.add(o);
        });
        return nodes;
    }

    private RubyHash convertArgs(PluginDefinition def) {
        RubyHash converted = RubyHash.newHash((Ruby)RubyUtil.RUBY);
        for (Map.Entry<String, Object> entry : def.getArguments().entrySet()) {
            Object toput;
            Object value = entry.getValue();
            String key = entry.getKey();
            if (value instanceof PluginStatement) {
                PluginDefinition codec = ((PluginStatement)value).getPluginDefinition();
                toput = this.pluginFactory.buildCodec(RubyUtil.RUBY.newString(codec.getName()), Rubyfier.deep(RubyUtil.RUBY, codec.getArguments()), codec.getArguments());
            } else {
                toput = value;
            }
            converted.put((Object)key, toput);
        }
        return converted;
    }

    private Map<String, Object> convertJavaArgs(PluginDefinition def) {
        for (Map.Entry<String, Object> entry : def.getArguments().entrySet()) {
            Object value = entry.getValue();
            String key = entry.getKey();
            if (!(value instanceof PluginStatement)) continue;
            PluginDefinition codec = ((PluginStatement)value).getPluginDefinition();
            IRubyObject toput = this.pluginFactory.buildCodec(RubyUtil.RUBY.newString(codec.getName()), Rubyfier.deep(RubyUtil.RUBY, codec.getArguments()), codec.getArguments());
            Codec javaCodec = (Codec)JavaUtil.unwrapJavaValue((IRubyObject)toput);
            def.getArguments().put(key, javaCodec);
        }
        return def.getArguments();
    }

    private boolean isFilter(Vertex vertex) {
        return this.filters.containsKey(vertex.getId());
    }

    private boolean isOutput(Vertex vertex) {
        return this.outputs.containsKey(vertex.getId());
    }

    private final class CompiledExecution {
        private final Map<String, SplitDataset> iffs = new HashMap<String, SplitDataset>(5);
        private final Map<String, Dataset> plugins = new HashMap<String, Dataset>(5);
        private final Dataset compiled = this.compile();

        CompiledExecution() {
        }

        Dataset toDataset() {
            return this.compiled;
        }

        private Dataset compile() {
            Collection outputNodes = CompiledPipeline.this.pipelineIR.getGraph().allLeaves().filter(x$0 -> CompiledPipeline.this.isOutput(x$0)).collect(Collectors.toList());
            if (outputNodes.isEmpty()) {
                return Dataset.IDENTITY;
            }
            return DatasetCompiler.terminalDataset(outputNodes.stream().map(leaf -> this.outputDataset((Vertex)leaf, this.flatten((Collection<Dataset>)Collections.emptyList(), (Vertex)leaf))).collect(Collectors.toList()));
        }

        private Dataset filterDataset(Vertex vertex, Collection<Dataset> datasets) {
            String vertexId = vertex.getId();
            if (!this.plugins.containsKey(vertexId)) {
                ComputeStepSyntaxElement<Dataset> prepared = DatasetCompiler.filterDataset(this.flatten(datasets, vertex), (AbstractFilterDelegatorExt)((Object)CompiledPipeline.this.filters.get(vertexId)));
                LOGGER.debug("Compiled filter\n {} \n into \n {}", (Object)vertex, prepared);
                this.plugins.put(vertexId, prepared.instantiate());
            }
            return this.plugins.get(vertexId);
        }

        private Dataset outputDataset(Vertex vertex, Collection<Dataset> datasets) {
            String vertexId = vertex.getId();
            if (!this.plugins.containsKey(vertexId)) {
                ComputeStepSyntaxElement<Dataset> prepared = DatasetCompiler.outputDataset(this.flatten(datasets, vertex), (AbstractOutputDelegatorExt)((Object)CompiledPipeline.this.outputs.get(vertexId)), CompiledPipeline.this.outputs.size() == 1);
                LOGGER.debug("Compiled output\n {} \n into \n {}", (Object)vertex, prepared);
                this.plugins.put(vertexId, prepared.instantiate());
            }
            return this.plugins.get(vertexId);
        }

        private SplitDataset split(Collection<Dataset> datasets, EventCondition condition, Vertex vertex) {
            String key = vertex.getId();
            SplitDataset conditional = this.iffs.get(key);
            if (conditional == null) {
                Collection<Dataset> dependencies = this.flatten(datasets, vertex);
                conditional = this.iffs.get(key);
                if (conditional == null) {
                    ComputeStepSyntaxElement<SplitDataset> prepared = DatasetCompiler.splitDataset(dependencies, condition);
                    LOGGER.debug("Compiled conditional\n {} \n into \n {}", (Object)vertex, prepared);
                    conditional = prepared.instantiate();
                    this.iffs.put(key, conditional);
                }
            }
            return conditional;
        }

        private Collection<Dataset> flatten(Collection<Dataset> datasets, Vertex start) {
            Collection<Dataset> result = this.compileDependencies(start, datasets, start.incomingVertices().filter(v -> CompiledPipeline.this.isFilter(v) || CompiledPipeline.this.isOutput(v) || v instanceof IfVertex));
            return result.isEmpty() ? datasets : result;
        }

        private Collection<Dataset> compileDependencies(Vertex start, Collection<Dataset> datasets, Stream<Vertex> dependencies) {
            return dependencies.map(dependency -> {
                if (CompiledPipeline.this.isFilter(dependency)) {
                    return this.filterDataset((Vertex)dependency, datasets);
                }
                if (CompiledPipeline.this.isOutput(dependency)) {
                    return this.outputDataset((Vertex)dependency, datasets);
                }
                IfVertex ifvert = (IfVertex)dependency;
                SplitDataset ifDataset = this.split(datasets, CompiledPipeline.this.conditionalCompiler.buildCondition(ifvert.getBooleanExpression()), (Vertex)dependency);
                if (ifvert.outgoingBooleanEdgesByType(true).anyMatch(edge -> Objects.equals(edge.getTo(), start))) {
                    return ifDataset;
                }
                return ifDataset.right();
            }).collect(Collectors.toList());
        }
    }
}

