/**
 * @file A `Foldable` with an additional index.
 * A `FoldableWithIndex` instance must be compatible with its `Foldable` instance
 *
 * ```ts
 * reduce(fa, b, f) = reduceWithIndex(fa, b, (_, b, a) => f(b, a))
 * foldMap(M)(fa, f) = foldMapWithIndex(M)(fa, (_, a) => f(a))
 * foldr(fa, b, f) = foldrWithIndex(fa, b, (_, a, b) => f(a, b))
 * ```
 */
import { getFoldableComposition } from './Foldable2v';
export function getFoldableWithIndexComposition(F, G) {
    return Object.assign({}, getFoldableComposition(F, G), { reduceWithIndex: (fga, b, f) => F.reduceWithIndex(fga, b, (fi, b, ga) => G.reduceWithIndex(ga, b, (gi, b, a) => f([fi, gi], b, a))), foldMapWithIndex: M => {
            const foldMapWithIndexF = F.foldMapWithIndex(M);
            const foldMapWithIndexG = G.foldMapWithIndex(M);
            return (fga, f) => foldMapWithIndexF(fga, (fi, ga) => foldMapWithIndexG(ga, (gi, a) => f([fi, gi], a)));
        }, foldrWithIndex: (fga, b, f) => F.foldrWithIndex(fga, b, (fi, ga, b) => G.foldrWithIndex(ga, b, (gi, a, b) => f([fi, gi], a, b))) });
}
