"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
function computeColorScales(colorDomain, chartColors) {
    return colorDomain.domain.reduce(function (acc, domainKey, index) {
        acc[domainKey] = chartColors.vizColors[index % chartColors.vizColors.length];
        return acc;
    }, {});
}
exports.computeColorScales = computeColorScales;
function getColor(chartColors, colorScales, colorAccessors) {
    return function (datum, yAccessor) {
        var key = getColorKey(datum, colorAccessors, yAccessor);
        return colorScales[key] || chartColors.defaultVizColor;
    };
}
exports.getColor = getColor;
function getColorKey(datum, colorAccessors, yAccessor) {
    return __spread(colorAccessors.map(function (accessor) { return String(datum[accessor]); }), [yAccessor]).filter(function (value) { return value; })
        .join('--');
}
exports.getColorKey = getColorKey;
//# sourceMappingURL=colors.js.map