"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * The position of the axis relative to the chart.
 * A left or right positioned axis is a vertical axis.
 * A top or bottom positioned axis is an horizontal axis.
 */
var Position;
(function (Position) {
    Position["Top"] = "top";
    Position["Bottom"] = "bottom";
    Position["Left"] = "left";
    Position["Right"] = "right";
})(Position = exports.Position || (exports.Position = {}));
exports.AnnotationTypes = Object.freeze({
    Line: 'line',
    Rectangle: 'rectangle',
    Text: 'text',
});
exports.AnnotationDomainTypes = Object.freeze({
    XDomain: 'xDomain',
    YDomain: 'yDomain',
});
function isLineAnnotation(spec) {
    return spec.annotationType === exports.AnnotationTypes.Line;
}
exports.isLineAnnotation = isLineAnnotation;
function isRectAnnotation(spec) {
    return spec.annotationType === exports.AnnotationTypes.Rectangle;
}
exports.isRectAnnotation = isRectAnnotation;
//# sourceMappingURL=specs.js.map