"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var Option_1 = require("fp-ts/lib/Option");
var SvgTextBBoxCalculator = /** @class */ (function () {
    // TODO specify styles for text
    // TODO specify how to hide the svg from the current dom view
    // like moving it a -9999999px
    function SvgTextBBoxCalculator(rootElement) {
        var xmlns = 'http://www.w3.org/2000/svg';
        this.svgElem = document.createElementNS(xmlns, 'svg');
        this.textElem = document.createElementNS(xmlns, 'text');
        this.svgElem.appendChild(this.textElem);
        this.textNode = document.createTextNode('');
        this.textElem.appendChild(this.textNode);
        this.attachedRoot = rootElement || document.documentElement;
        this.attachedRoot.appendChild(this.svgElem);
    }
    SvgTextBBoxCalculator.prototype.compute = function (text) {
        this.textNode.textContent = text;
        var rect = this.textElem.getBoundingClientRect();
        return Option_1.some({
            width: rect.width,
            height: rect.height,
        });
    };
    SvgTextBBoxCalculator.prototype.destroy = function () {
        this.attachedRoot.removeChild(this.svgElem);
    };
    return SvgTextBBoxCalculator;
}());
exports.SvgTextBBoxCalculator = SvgTextBBoxCalculator;
//# sourceMappingURL=svg_text_bbox_calculator.js.map