/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.RubyInstanceConfig;
import org.jruby.RubyString;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.specialized.OneOperandArgNoBlockCallInstr;
import org.jruby.ir.operands.FrozenString;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class ArrayDerefInstr
extends OneOperandArgNoBlockCallInstr {
    private final FrozenString key;
    public static final ByteList AREF = new ByteList(new byte[]{91, 93});
    public static final ByteList ASET = new ByteList(new byte[]{91, 93, 61});

    public static ArrayDerefInstr create(IRScope scope, Variable result2, Operand obj, FrozenString arg0) {
        return new ArrayDerefInstr(scope, result2, obj, arg0);
    }

    public ArrayDerefInstr(IRScope scope, Variable result2, Operand obj, FrozenString arg0, CallSite callSite, long callSiteId) {
        super(scope, Operation.ARRAY_DEREF, CallType.FUNCTIONAL, result2, scope.getManager().getRuntime().newSymbol(AREF), obj, new Operand[]{arg0}, false, callSite, callSiteId);
        this.key = arg0;
    }

    public ArrayDerefInstr(IRScope scope, Variable result2, Operand obj, FrozenString arg0) {
        super(scope, Operation.ARRAY_DEREF, CallType.FUNCTIONAL, result2, scope.getManager().getRuntime().newSymbol(AREF), obj, new Operand[]{arg0}, false);
        this.key = arg0;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new ArrayDerefInstr(ii.getScope(), (Variable)this.getResult().cloneForInlining(ii), this.getReceiver().cloneForInlining(ii), this.key, this.getCallSite(), this.getCallSiteId());
    }

    @Override
    public void encode(IRWriterEncoder e) {
        if (RubyInstanceConfig.IR_WRITING_DEBUG) {
            System.out.println("Instr(" + (Object)((Object)this.getOperation()) + "): " + this);
        }
        e.encode(this.getOperation());
        e.encode(this.getResult());
        e.encode(this.getReceiver());
        e.encode(this.getArg1());
    }

    public static ArrayDerefInstr decode(IRReaderDecoder d) {
        return ArrayDerefInstr.create(d.getCurrentScope(), d.decodeVariable(), d.decodeOperand(), (FrozenString)d.decodeOperand());
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope dynamicScope, IRubyObject self2, Object[] temp) {
        IRubyObject object = (IRubyObject)this.getReceiver().retrieve(context, self2, currScope, dynamicScope, temp);
        RubyString keyStr = (RubyString)this.key.retrieve(context, self2, currScope, dynamicScope, temp);
        return IRRuntimeHelpers.callOptimizedAref(context, self2, object, keyStr, this.getCallSite());
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.ArrayDerefInstr(this);
    }

    public FrozenString getKey() {
        return this.key;
    }
}

