/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.debuginfo;

import com.android.dex.Dex;
import jadx.core.dex.attributes.nodes.SourceFileAttr;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.DexNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.debuginfo.LocalVar;
import jadx.core.utils.exceptions.DecodeException;
import java.util.ArrayList;
import java.util.List;

public class DebugInfoParser {
    private static final int DBG_END_SEQUENCE = 0;
    private static final int DBG_ADVANCE_PC = 1;
    private static final int DBG_ADVANCE_LINE = 2;
    private static final int DBG_START_LOCAL = 3;
    private static final int DBG_START_LOCAL_EXTENDED = 4;
    private static final int DBG_END_LOCAL = 5;
    private static final int DBG_RESTART_LOCAL = 6;
    private static final int DBG_SET_PROLOGUE_END = 7;
    private static final int DBG_SET_EPILOGUE_BEGIN = 8;
    private static final int DBG_SET_FILE = 9;
    private static final int DBG_FIRST_SPECIAL = 10;
    private static final int DBG_LINE_BASE = -4;
    private static final int DBG_LINE_RANGE = 15;
    private final MethodNode mth;
    private final Dex.Section section;
    private final DexNode dex;
    private final LocalVar[] locals;
    private final InsnNode[] insnByOffset;
    private List<LocalVar> resultList;

    public DebugInfoParser(MethodNode mth, int debugOffset, InsnNode[] insnByOffset) {
        this.mth = mth;
        this.dex = mth.dex();
        this.section = this.dex.openSection(debugOffset);
        int regsCount = mth.getRegsCount();
        this.locals = new LocalVar[regsCount];
        this.insnByOffset = insnByOffset;
    }

    public List<LocalVar> process() throws DecodeException {
        boolean varsInfoFound = false;
        this.resultList = new ArrayList<LocalVar>();
        int addr = 0;
        int line = this.section.readUleb128();
        int paramsCount = this.section.readUleb128();
        List<RegisterArg> mthArgs = this.mth.getArguments(false);
        for (int i = 0; i < paramsCount; ++i) {
            int nameId = this.section.readUleb128() - 1;
            if (nameId == -1) continue;
            String name = this.dex.getString(nameId);
            if (i >= mthArgs.size() || name == null) continue;
            RegisterArg arg = mthArgs.get(i);
            int regNum = arg.getRegNum();
            LocalVar lVar = new LocalVar(regNum, name, arg.getInitType());
            this.startVar(lVar, -1);
            varsInfoFound = true;
        }
        this.addrChange(-1, 1, line);
        this.setLine(addr, line);
        int c = this.section.readByte() & 0xFF;
        while (c != 0) {
            switch (c) {
                case 1: {
                    int addrInc = this.section.readUleb128();
                    addr = this.addrChange(addr, addrInc, line);
                    this.setLine(addr, line);
                    break;
                }
                case 2: {
                    line += this.section.readSleb128();
                    break;
                }
                case 3: {
                    int regNum = this.section.readUleb128();
                    int nameId = this.section.readUleb128() - 1;
                    int type = this.section.readUleb128() - 1;
                    LocalVar var = new LocalVar(this.dex, regNum, nameId, type, -1);
                    this.startVar(var, addr);
                    varsInfoFound = true;
                    break;
                }
                case 4: {
                    int regNum = this.section.readUleb128();
                    int nameId = this.section.readUleb128() - 1;
                    int type = this.section.readUleb128() - 1;
                    int sign = this.section.readUleb128() - 1;
                    LocalVar var = new LocalVar(this.dex, regNum, nameId, type, sign);
                    this.startVar(var, addr);
                    varsInfoFound = true;
                    break;
                }
                case 6: {
                    int regNum = this.section.readUleb128();
                    this.restartVar(regNum, addr);
                    varsInfoFound = true;
                    break;
                }
                case 5: {
                    int regNum = this.section.readUleb128();
                    LocalVar var = this.locals[regNum];
                    if (var != null) {
                        this.endVar(var, addr);
                    }
                    varsInfoFound = true;
                    break;
                }
                case 7: 
                case 8: {
                    break;
                }
                case 9: {
                    int idx = this.section.readUleb128() - 1;
                    if (idx == -1) break;
                    String sourceFile = this.dex.getString(idx);
                    this.mth.addAttr(new SourceFileAttr(sourceFile));
                    break;
                }
                default: {
                    if (c >= 10) {
                        int adjustedOpCode = c - 10;
                        int addrInc = adjustedOpCode / 15;
                        addr = this.addrChange(addr, addrInc, line);
                        this.setLine(addr, line += -4 + adjustedOpCode % 15);
                        break;
                    }
                    throw new DecodeException("Unknown debug insn code: " + c);
                }
            }
            c = this.section.readByte() & 0xFF;
        }
        if (varsInfoFound) {
            for (LocalVar var : this.locals) {
                if (var == null || var.isEnd()) continue;
                this.endVar(var, this.mth.getCodeSize() - 1);
            }
        }
        this.setSourceLines(addr, this.insnByOffset.length, line);
        return this.resultList;
    }

    private int addrChange(int addr, int addrInc, int line) {
        int newAddr = addr + addrInc;
        int maxAddr = this.insnByOffset.length - 1;
        newAddr = Math.min(newAddr, maxAddr);
        this.setSourceLines(addr, newAddr, line);
        return newAddr;
    }

    private void setSourceLines(int start, int end, int line) {
        for (int offset = start + 1; offset < end; ++offset) {
            this.setLine(offset, line);
        }
    }

    private void setLine(int offset, int line) {
        InsnNode insn = this.insnByOffset[offset];
        if (insn != null) {
            insn.setSourceLine(line);
        }
    }

    private void restartVar(int regNum, int addr) {
        LocalVar prev = this.locals[regNum];
        if (prev != null) {
            this.endVar(prev, addr);
            LocalVar newVar = new LocalVar(regNum, prev.getName(), prev.getType());
            this.startVar(newVar, addr);
        } else {
            this.mth.addComment("Debug info: failed to restart local var, previous not found, register: " + regNum);
        }
    }

    private void startVar(LocalVar newVar, int addr) {
        int regNum = newVar.getRegNum();
        LocalVar prev = this.locals[regNum];
        if (prev != null) {
            this.endVar(prev, addr);
        }
        newVar.start(addr);
        this.locals[regNum] = newVar;
    }

    private void endVar(LocalVar var, int addr) {
        if (var.end(addr)) {
            this.resultList.add(var);
        }
    }
}

