/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.internal.publisher;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.gradle.api.Action;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.XmlProvider;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MetaDataParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionRangeSelector;
import org.gradle.api.publish.internal.versionmapping.VersionMappingStrategyInternal;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.publish.ivy.IvyConfiguration;
import org.gradle.api.publish.ivy.IvyModuleDescriptorAuthor;
import org.gradle.api.publish.ivy.IvyModuleDescriptorDescription;
import org.gradle.api.publish.ivy.IvyModuleDescriptorLicense;
import org.gradle.api.publish.ivy.internal.dependency.IvyDependencyInternal;
import org.gradle.api.publish.ivy.internal.dependency.IvyExcludeRule;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublicationIdentity;
import org.gradle.internal.xml.SimpleXmlWriter;
import org.gradle.internal.xml.XmlTransformer;
import org.gradle.util.CollectionUtils;

public class IvyDescriptorFileGenerator {
    private static final String IVY_FILE_ENCODING = "UTF-8";
    private static final String IVY_DATE_PATTERN = "yyyyMMddHHmmss";
    private static final Action<XmlProvider> ADD_GRADLE_METADATA_MARKER = new Action<XmlProvider>(){

        public void execute(XmlProvider xmlProvider) {
            StringBuilder builder = xmlProvider.asString();
            int idx = builder.indexOf("<info");
            builder.insert(idx, IvyDescriptorFileGenerator.xmlComments(MetaDataParser.GRADLE_METADATA_MARKER_COMMENT_LINES) + "  " + IvyDescriptorFileGenerator.xmlComment("do-not-remove: published-with-gradle-metadata") + "  ");
        }
    };
    private final SimpleDateFormat ivyDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private final IvyPublicationIdentity projectIdentity;
    private final VersionMappingStrategyInternal versionMappingStrategy;
    private String branch;
    private String status;
    private List<IvyModuleDescriptorLicense> licenses = new ArrayList<IvyModuleDescriptorLicense>();
    private List<IvyModuleDescriptorAuthor> authors = new ArrayList<IvyModuleDescriptorAuthor>();
    private IvyModuleDescriptorDescription description;
    private Map<QName, String> extraInfo;
    private XmlTransformer xmlTransformer = new XmlTransformer();
    private List<IvyConfiguration> configurations = new ArrayList<IvyConfiguration>();
    private List<IvyArtifact> artifacts = new ArrayList<IvyArtifact>();
    private List<IvyDependencyInternal> dependencies = new ArrayList<IvyDependencyInternal>();
    private List<IvyExcludeRule> globalExcludes = new ArrayList<IvyExcludeRule>();

    public IvyDescriptorFileGenerator(IvyPublicationIdentity projectIdentity, boolean writeGradleRedirectionMarker, VersionMappingStrategyInternal versionMappingStrategy) {
        this.projectIdentity = projectIdentity;
        this.versionMappingStrategy = versionMappingStrategy;
        if (writeGradleRedirectionMarker) {
            this.xmlTransformer.addFinalizer(ADD_GRADLE_METADATA_MARKER);
        }
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public IvyDescriptorFileGenerator addLicense(IvyModuleDescriptorLicense ivyLicense) {
        this.licenses.add(ivyLicense);
        return this;
    }

    public IvyDescriptorFileGenerator addAuthor(IvyModuleDescriptorAuthor ivyAuthor) {
        this.authors.add(ivyAuthor);
        return this;
    }

    public void setDescription(IvyModuleDescriptorDescription ivyDescription) {
        this.description = ivyDescription;
    }

    public Map<QName, String> getExtraInfo() {
        return this.extraInfo;
    }

    public void setExtraInfo(Map<QName, String> extraInfo) {
        this.extraInfo = extraInfo;
    }

    public IvyDescriptorFileGenerator addConfiguration(IvyConfiguration ivyConfiguration) {
        this.configurations.add(ivyConfiguration);
        return this;
    }

    public IvyDescriptorFileGenerator addArtifact(IvyArtifact ivyArtifact) {
        this.artifacts.add(ivyArtifact);
        return this;
    }

    public IvyDescriptorFileGenerator addDependency(IvyDependencyInternal ivyDependency) {
        this.dependencies.add(ivyDependency);
        return this;
    }

    public IvyDescriptorFileGenerator addGlobalExclude(IvyExcludeRule excludeRule) {
        this.globalExcludes.add(excludeRule);
        return this;
    }

    public IvyDescriptorFileGenerator withXml(Action<XmlProvider> action) {
        this.xmlTransformer.addAction(action);
        return this;
    }

    public IvyDescriptorFileGenerator writeTo(File file) {
        this.xmlTransformer.transform(file, IVY_FILE_ENCODING, (Action)new Action<Writer>(){

            public void execute(Writer writer) {
                try {
                    IvyDescriptorFileGenerator.this.writeDescriptor(writer);
                }
                catch (IOException e) {
                    throw new UncheckedIOException((Throwable)e);
                }
            }
        });
        return this;
    }

    private void writeDescriptor(Writer writer) throws IOException {
        OptionalAttributeXmlWriter xmlWriter = new OptionalAttributeXmlWriter(writer, "  ", IVY_FILE_ENCODING);
        xmlWriter.startElement("ivy-module").attribute("version", "2.0");
        if (this.usesClassifier()) {
            xmlWriter.attribute("xmlns:m", "http://ant.apache.org/ivy/maven");
        }
        xmlWriter.startElement("info").attribute("organisation", this.projectIdentity.getOrganisation()).attribute("module", this.projectIdentity.getModule()).attribute("branch", this.branch).attribute("revision", this.projectIdentity.getRevision()).attribute("status", this.status).attribute("publication", this.ivyDateFormat.format(new Date()));
        for (IvyModuleDescriptorLicense ivyModuleDescriptorLicense : this.licenses) {
            xmlWriter.startElement("license").attribute("name", (String)ivyModuleDescriptorLicense.getName().getOrNull()).attribute("url", (String)ivyModuleDescriptorLicense.getUrl().getOrNull()).endElement();
        }
        for (IvyModuleDescriptorAuthor ivyModuleDescriptorAuthor : this.authors) {
            xmlWriter.startElement("ivyauthor").attribute("name", (String)ivyModuleDescriptorAuthor.getName().getOrNull()).attribute("url", (String)ivyModuleDescriptorAuthor.getUrl().getOrNull()).endElement();
        }
        if (this.description != null) {
            xmlWriter.startElement("description").attribute("homepage", (String)this.description.getHomepage().getOrNull()).characters((CharSequence)this.description.getText().getOrElse((Object)"")).endElement();
        }
        if (this.extraInfo != null) {
            for (Map.Entry entry : this.extraInfo.entrySet()) {
                if (entry.getKey() == null) continue;
                xmlWriter.startElement("ns:" + ((QName)entry.getKey()).getLocalPart()).attribute("xmlns:ns", ((QName)entry.getKey()).getNamespaceURI()).characters((CharSequence)entry.getValue()).endElement();
            }
        }
        xmlWriter.endElement();
        this.writeConfigurations(xmlWriter);
        this.writePublications(xmlWriter);
        this.writeDependencies(xmlWriter);
        xmlWriter.endElement();
    }

    private boolean usesClassifier() {
        for (IvyArtifact artifact : this.artifacts) {
            if (artifact.getClassifier() == null) continue;
            return true;
        }
        for (IvyDependencyInternal dependency : this.dependencies) {
            for (DependencyArtifact dependencyArtifact : dependency.getArtifacts()) {
                if (dependencyArtifact.getClassifier() == null) continue;
                return true;
            }
        }
        return false;
    }

    private void writeConfigurations(OptionalAttributeXmlWriter xmlWriter) throws IOException {
        xmlWriter.startElement("configurations");
        for (IvyConfiguration configuration : this.configurations) {
            xmlWriter.startElement("conf").attribute("name", configuration.getName()).attribute("visibility", "public");
            if (configuration.getExtends().size() > 0) {
                xmlWriter.attribute("extends", CollectionUtils.join((String)",", configuration.getExtends()));
            }
            xmlWriter.endElement();
        }
        xmlWriter.endElement();
    }

    private void writePublications(OptionalAttributeXmlWriter xmlWriter) throws IOException {
        xmlWriter.startElement("publications");
        for (IvyArtifact artifact : this.artifacts) {
            xmlWriter.startElement("artifact").attribute("name", artifact.getName()).attribute("type", artifact.getType()).attribute("ext", artifact.getExtension()).attribute("conf", artifact.getConf()).attribute("m:classifier", artifact.getClassifier()).endElement();
        }
        xmlWriter.endElement();
    }

    private void writeDependencies(OptionalAttributeXmlWriter xmlWriter) throws IOException {
        xmlWriter.startElement("dependencies");
        for (IvyDependencyInternal dependency : this.dependencies) {
            String resolvedVersion = this.versionMappingStrategy.findStrategyForVariant(dependency.getAttributes()).maybeResolveVersion(dependency.getOrganisation(), dependency.getModule());
            xmlWriter.startElement("dependency").attribute("org", dependency.getOrganisation()).attribute("name", dependency.getModule()).attribute("rev", resolvedVersion != null ? resolvedVersion : dependency.getRevision()).attribute("conf", dependency.getConfMapping());
            if (resolvedVersion != null && this.isDynamicVersion(dependency.getRevision())) {
                xmlWriter.attribute("revConstraint", dependency.getRevision());
            }
            if (!dependency.isTransitive()) {
                xmlWriter.attribute("transitive", "false");
            }
            for (DependencyArtifact dependencyArtifact : dependency.getArtifacts()) {
                this.printDependencyArtifact(dependencyArtifact, xmlWriter);
            }
            for (ExcludeRule excludeRule : dependency.getExcludeRules()) {
                this.writeDependencyExclude(excludeRule, xmlWriter);
            }
            xmlWriter.endElement();
        }
        for (IvyExcludeRule excludeRule : this.globalExcludes) {
            this.writeGlobalExclude(excludeRule, xmlWriter);
        }
        xmlWriter.endElement();
    }

    private boolean isDynamicVersion(String version) {
        return VersionRangeSelector.ALL_RANGE.matcher(version).matches() || version.endsWith("+") || version.startsWith("latest.");
    }

    private void writeDependencyExclude(ExcludeRule excludeRule, OptionalAttributeXmlWriter xmlWriter) throws IOException {
        xmlWriter.startElement("exclude").attribute("org", excludeRule.getGroup()).attribute("module", excludeRule.getModule()).endElement();
    }

    private void printDependencyArtifact(DependencyArtifact dependencyArtifact, OptionalAttributeXmlWriter xmlWriter) throws IOException {
        xmlWriter.startElement("artifact").attribute("name", dependencyArtifact.getName()).attribute("type", dependencyArtifact.getType()).attribute("ext", dependencyArtifact.getExtension()).attribute("m:classifier", dependencyArtifact.getClassifier()).endElement();
    }

    private void writeGlobalExclude(IvyExcludeRule excludeRule, OptionalAttributeXmlWriter xmlWriter) throws IOException {
        xmlWriter.startElement("exclude").attribute("org", excludeRule.getOrg()).attribute("module", excludeRule.getModule()).attribute("conf", excludeRule.getConf()).endElement();
    }

    private static String xmlComments(String[] lines) {
        return Joiner.on((String)"  ").join(Iterables.transform(Arrays.asList(lines), IvyDescriptorFileGenerator::xmlComment));
    }

    private static String xmlComment(String content) {
        return "<!-- " + content + " -->\n";
    }

    private static class OptionalAttributeXmlWriter
    extends SimpleXmlWriter {
        public OptionalAttributeXmlWriter(Writer writer, String indent, String encoding) throws IOException {
            super(writer, indent, encoding);
        }

        public OptionalAttributeXmlWriter startElement(String name) throws IOException {
            super.startElement(name);
            return this;
        }

        public OptionalAttributeXmlWriter attribute(String name, String value) throws IOException {
            if (value != null) {
                super.attribute(name, value);
            }
            return this;
        }

        public OptionalAttributeXmlWriter comment(String comment) throws IOException {
            super.comment(comment);
            return this;
        }
    }
}

