/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import java.util.Collection;
import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.provider.TransformBackedProvider;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.provider.Provider;
import org.gradle.internal.state.Managed;
import org.gradle.util.GUtil;

public abstract class AbstractMinimalProvider<T>
implements ProviderInternal<T>,
Managed {
    private static final Managed.Factory FACTORY = new Managed.Factory(){

        @Override
        @Nullable
        public <T> T fromState(Class<T> type, Object state) {
            if (!type.isAssignableFrom(Provider.class)) {
                return null;
            }
            if (state == null) {
                return type.cast(Providers.notDefined());
            }
            return type.cast(Providers.of(state));
        }
    };

    @Override
    public <S> ProviderInternal<S> map(Transformer<? extends S, ? super T> transformer) {
        return new TransformBackedProvider<S, T>(transformer, this);
    }

    public <S> Provider<S> flatMap(Transformer<? extends Provider<? extends S>, ? super T> transformer) {
        return new FlatMapProvider(this, transformer);
    }

    public boolean isPresent() {
        return this.getOrNull() != null;
    }

    public T getOrElse(T defaultValue) {
        Object value = this.getOrNull();
        if (value == null) {
            return defaultValue;
        }
        return (T)value;
    }

    @Override
    public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
        return false;
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        if (!this.maybeVisitBuildDependencies(context)) {
            Object value = this.get();
            if (value instanceof Collection) {
                Collection items = (Collection)value;
                for (Object item : items) {
                    context.maybeAdd(item);
                }
            } else {
                context.maybeAdd(value);
            }
        }
    }

    @Override
    public ProviderInternal<T> withFinalValue() {
        Object value = this.getOrNull();
        if (value == null) {
            return Providers.notDefined();
        }
        return Providers.of(value);
    }

    public String toString() {
        return String.format("provider(%s)", GUtil.elvis(this.getType(), (Object)"?"));
    }

    @Override
    public boolean immutable() {
        return false;
    }

    @Override
    public Class<?> publicType() {
        return Provider.class;
    }

    @Override
    public Managed.Factory managedFactory() {
        return FACTORY;
    }

    @Override
    public Object unpackState() {
        return this.getOrNull();
    }

    private static class FlatMapProvider<S, T>
    extends AbstractMinimalProvider<S> {
        private final Provider<? extends T> provider;
        private final Transformer<? extends Provider<? extends S>, ? super T> transformer;

        FlatMapProvider(ProviderInternal<? extends T> provider, Transformer<? extends Provider<? extends S>, ? super T> transformer) {
            this.provider = provider;
            this.transformer = transformer;
        }

        @Override
        @Nullable
        public Class<S> getType() {
            return null;
        }

        @Override
        public boolean isPresent() {
            Object value = this.provider.getOrNull();
            if (value == null) {
                return false;
            }
            return this.map(value).isPresent();
        }

        public S get() {
            Object value = this.provider.get();
            return (S)this.map(value).get();
        }

        @Nullable
        public S getOrNull() {
            Object value = this.provider.getOrNull();
            if (value == null) {
                return null;
            }
            return (S)this.map(value).getOrNull();
        }

        private Provider<? extends S> map(T value) {
            Provider result = (Provider)this.transformer.transform(value);
            if (result == null) {
                throw new IllegalStateException("Transformer for this provider returned a null value.");
            }
            return result;
        }

        @Override
        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            return Providers.internal(this.map(this.provider.get())).maybeVisitBuildDependencies(context);
        }

        @Override
        public String toString() {
            return "flatmap(" + this.provider + ")";
        }
    }
}

