/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.disassembly.viewer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.cdt.debug.internal.ui.disassembly.viewer.DocumentAnnotationProvider;
import org.eclipse.cdt.debug.internal.ui.disassembly.viewer.DocumentContentProvider;
import org.eclipse.cdt.debug.internal.ui.disassembly.viewer.DocumentLabelProvider;
import org.eclipse.cdt.debug.ui.disassembly.IDocumentPresentation;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;

public class VirtualDocument
extends Document {
    public static final String CATEGORY_LINE = "category_line";
    private static final String PENDING_LINE = "..............................";
    private Object fRoot;
    private int fCurrentOffset = 0;
    private IDocumentPresentation fPresentationContext;
    private AnnotationModel fAnnotationModel;
    private DocumentContentProvider fContentProvider;
    private DocumentLabelProvider fLabelProvider;
    private DocumentAnnotationProvider fAnnotationProvider;

    public VirtualDocument(AnnotationModel annotationModel, IDocumentPresentation presentationContext, Object root) {
        this.fRoot = root;
        this.fPresentationContext = presentationContext;
        this.fAnnotationModel = annotationModel;
        this.fContentProvider = new DocumentContentProvider(this);
        this.fLabelProvider = new DocumentLabelProvider(this);
        this.fAnnotationProvider = new DocumentAnnotationProvider(this);
        this.getContentProvider().init(this.fRoot);
    }

    public void dispose() {
        this.getContentProvider().dispose();
        this.getLabelProvider().dispose();
        this.getAnnotationProvider().dispose();
        this.fRoot = null;
    }

    protected void completeInitialization() {
        super.completeInitialization();
        this.addPositionCategory(CATEGORY_LINE);
        this.addPositionUpdater((IPositionUpdater)new DefaultPositionUpdater(CATEGORY_LINE));
    }

    public IDocumentPresentation getPresentationContext() {
        return this.fPresentationContext;
    }

    public AnnotationModel getAnnotationModel() {
        return this.fAnnotationModel;
    }

    public DocumentContentProvider getContentProvider() {
        return this.fContentProvider;
    }

    protected DocumentLabelProvider getLabelProvider() {
        return this.fLabelProvider;
    }

    protected DocumentAnnotationProvider getAnnotationProvider() {
        return this.fAnnotationProvider;
    }

    private String createPendingContent(int lineCount, int oldOffset, int offset) {
        int i;
        int oldLineCount = this.getNumberOfLines() - 1;
        int intersectStart = Math.max(oldOffset, offset);
        int intersectEnd = Math.min(oldOffset + oldLineCount, offset + lineCount);
        int intersectCount = intersectEnd - intersectStart;
        StringBuilder sb = new StringBuilder();
        int line = 0;
        if (oldOffset > offset) {
            i = 0;
            while (i < oldOffset - offset) {
                try {
                    this.addPosition(CATEGORY_LINE, new LinePosition(sb.length(), offset - i));
                    sb.append(PENDING_LINE).append('\n');
                    ++line;
                }
                catch (BadLocationException badLocationException) {
                }
                catch (BadPositionCategoryException badPositionCategoryException) {
                    // empty catch block
                }
                ++i;
            }
        } else {
            line += offset - oldOffset;
        }
        i = 0;
        while (i < intersectCount) {
            try {
                IRegion region = this.getLineInformation(line++);
                sb.append(this.get(region.getOffset(), region.getLength())).append('\n');
            }
            catch (BadLocationException region) {
                // empty catch block
            }
            ++i;
        }
        int pendingLines = 0;
        if (oldLineCount < lineCount) {
            pendingLines = lineCount - oldLineCount;
        } else if (offset > oldOffset) {
            pendingLines = offset - oldOffset;
        }
        int i2 = 0;
        while (i2 < pendingLines) {
            sb.append(PENDING_LINE).append('\n');
            ++line;
            ++i2;
        }
        return sb.toString();
    }

    public int getCurrentOffset() {
        return this.fCurrentOffset;
    }

    public void setCurrentOffset(int offset) {
        this.fCurrentOffset = offset;
    }

    public Object getElementAtLine(int line) {
        return this.getContentProvider().getElementAtLine(line);
    }

    public void updateContent(int lineCount, int offset, boolean revealInput) {
        int oldOffset = this.fCurrentOffset;
        this.fCurrentOffset = offset;
        this.removePositions();
        this.getAnnotationModel().removeAllAnnotations();
        this.set(this.createPendingContent(lineCount, oldOffset, offset));
        this.setPositions();
        this.getContentProvider().update(this.getPresentationContext(), lineCount, offset, revealInput);
    }

    protected void updateElement(Object input, int index, Object element) {
        this.getLabelProvider().update(input, element, index, this.getPresentationContext());
        this.getAnnotationProvider().update(this.getContentProvider().getInput(), element, index, this.getPresentationContext());
    }

    protected void updateAnnotations(int lineNumber, Annotation[] annotations) {
        AnnotationModel annotationModel = this.getAnnotationModel();
        try {
            Position[] positions = this.getPositions(CATEGORY_LINE);
            if (lineNumber < positions.length) {
                Annotation ann2;
                Iterator it = annotationModel.getAnnotationIterator();
                ArrayList<Annotation> oldAnnotations = new ArrayList<Annotation>(3);
                while (it.hasNext()) {
                    ann2 = (Annotation)it.next();
                    if (!positions[lineNumber].equals((Object)annotationModel.getPosition(ann2))) continue;
                    oldAnnotations.add(ann2);
                }
                for (Annotation ann2 : oldAnnotations) {
                    annotationModel.removeAnnotation(ann2);
                }
                Annotation[] annotationArray = annotations;
                int n = annotations.length;
                int n2 = 0;
                while (n2 < n) {
                    ann2 = annotationArray[n2];
                    annotationModel.addAnnotation(ann2, positions[lineNumber]);
                    ++n2;
                }
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            // empty catch block
        }
    }

    final void labelDone(Object element, int lineNumber, Properties labels) {
        try {
            String line = labels.getProperty("lineLabel");
            IRegion region = this.getLineInformation(lineNumber);
            if (this.get(region.getOffset(), region.getLength()).compareTo(line) != 0) {
                this.replace(region.getOffset(), region.getLength(), line);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    protected void removeLine(int lineNumber) {
        try {
            IRegion region = this.getLineInformation(lineNumber);
            this.replace(region.getOffset(), region.getLength(), "");
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void removePositions() {
        try {
            Position[] oldPositions;
            Position[] positionArray = oldPositions = this.getPositions(CATEGORY_LINE);
            int n = oldPositions.length;
            int n2 = 0;
            while (n2 < n) {
                Position p = positionArray[n2];
                this.removePosition(CATEGORY_LINE, p);
                ++n2;
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            // empty catch block
        }
    }

    private void setPositions() {
        try {
            Position[] oldPositions = this.getPositions(CATEGORY_LINE);
            int offset = this.getCurrentOffset();
            int lines = this.getNumberOfLines();
            Position[] positionArray = oldPositions;
            int n = oldPositions.length;
            int n2 = 0;
            while (n2 < n) {
                Position p = positionArray[n2];
                this.removePosition(CATEGORY_LINE, p);
                ++n2;
            }
            int i = 0;
            while (i < lines) {
                IRegion info = this.getLineInformation(i);
                this.addPosition(CATEGORY_LINE, new LinePosition(info.getOffset(), info.getLength(), offset + i));
                ++i;
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public class LinePosition
    extends Position {
        private int fDistance;

        LinePosition(int offset, int distance) {
            super(offset);
            this.fDistance = 0;
            this.fDistance = distance;
        }

        LinePosition(int offset, int length, int distance) {
            super(offset, length);
            this.fDistance = 0;
            this.fDistance = distance;
        }

        int getDistance() {
            return this.fDistance;
        }

        public boolean equals(Object other) {
            if (!(other instanceof LinePosition)) {
                return false;
            }
            return this.getDistance() == ((LinePosition)((Object)other)).getDistance();
        }
    }
}

