/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaMethodBreakpoint;
import org.eclipse.jdt.internal.debug.core.refactoring.LineBreakpointChange;

public abstract class MethodBreakpointChange
extends LineBreakpointChange {
    private String fMethodName;
    private String fSignature;
    private boolean fEntry;
    private boolean fExit;
    private boolean fNativeOnly;

    public MethodBreakpointChange(IJavaMethodBreakpoint breakpoint) throws CoreException {
        super((IJavaLineBreakpoint)breakpoint);
        this.fMethodName = breakpoint.getMethodName();
        this.fSignature = breakpoint.getMethodSignature();
        this.fEntry = breakpoint.isEntry();
        this.fExit = breakpoint.isExit();
        this.fNativeOnly = breakpoint.isNativeOnly();
    }

    protected String getMethodName() {
        return this.fMethodName;
    }

    protected String getSignature() {
        return this.fSignature;
    }

    protected boolean isEntry() {
        return this.fEntry;
    }

    protected boolean isExit() {
        return this.fExit;
    }

    protected boolean isNativeOnly() {
        return this.fNativeOnly;
    }

    protected void apply(IJavaMethodBreakpoint breakpoint) throws CoreException {
        super.apply((IJavaLineBreakpoint)breakpoint);
        breakpoint.setEntry(this.fEntry);
        breakpoint.setExit(this.fExit);
        breakpoint.setNativeOnly(this.fNativeOnly);
    }
}

