/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.db;

import java.util.Properties;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ui.ProfileUIManager;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.util.DesignUtil;
import org.eclipse.datatools.connectivity.oda.profile.internal.OdaConnectionProfile;
import org.eclipse.datatools.connectivity.ui.wizards.ProfilePropertyPage;

public class DbProfileUtil {
    private static final String DB_PROFILE_PROVIDER_ID = "org.eclipse.datatools.connectivity.oda.profile.db.provider.id";

    static String getDbProviderIdFromProfileProperties(OdaConnectionProfile odaDbProfile) {
        Properties profileProps = odaDbProfile.getBaseProperties();
        return profileProps.getProperty(DB_PROFILE_PROVIDER_ID);
    }

    static void setDbProviderIdInProperties(Properties dbProfileProps, String dbProviderId) {
        if (dbProfileProps != null && dbProviderId != null) {
            dbProfileProps.setProperty(DB_PROFILE_PROVIDER_ID, dbProviderId);
        }
    }

    static ProfilePropertyPage createDbPropertyPage(OdaConnectionProfile odaDbProfile, String odaWrapperExtensionId) {
        if (!odaDbProfile.hasWrappedProfile()) {
            return null;
        }
        DbProfileUtil.updateProfileDbProviderInfo(odaDbProfile, odaWrapperExtensionId);
        odaDbProfile.setHideWrapperId(true);
        return ProfileUIManager.createPropertyPage((IConnectionProfile)odaDbProfile);
    }

    private static void updateProfileDbProviderInfo(OdaConnectionProfile odaDbProfile, String odaWrapperExtensionId) {
        String dbProviderId = DbProfileUtil.getDbProviderIdFromProfileProperties(odaDbProfile);
        odaDbProfile.setDirectProviderId(dbProviderId);
        odaDbProfile.setOdaWrapperExtensionId(odaWrapperExtensionId);
    }

    static void updateDataSourceDesignExternalProfileProvider(DataSourceDesign design, Properties dbPropertyValues) throws OdaException {
        if (dbPropertyValues == null || dbPropertyValues.isEmpty()) {
            return;
        }
        DbProfileUtil.updateDbProviderIdInDesign(design, dbPropertyValues);
    }

    private static void updateDbProviderIdInDesign(DataSourceDesign design, Properties dbPropertyValues) {
        String dbProviderIdKey = DB_PROFILE_PROVIDER_ID;
        if (dbPropertyValues.containsKey(dbProviderIdKey)) {
            Properties designProps = new Properties();
            designProps.setProperty(dbProviderIdKey, dbPropertyValues.getProperty(dbProviderIdKey));
            design.setPrivateProperties(DesignUtil.convertToDesignProperties((Properties)designProps));
        }
    }
}

