"use strict";
var path = require("path");
var ts_module = require("typescript/lib/tsserverlibrary");
var createMatchers_1 = require("./helpers/createMatchers");
var cssSnapshots_1 = require("./helpers/cssSnapshots");
function init(_a) {
    var ts = _a.typescript;
    var _isCSS;
    function create(info) {
        // User options for plugin.
        var options = info.config.options || {};
        // Create matchers using options object.
        var _a = createMatchers_1.createMatchers(options), isCSS = _a.isCSS, isRelativeCSS = _a.isRelativeCSS;
        _isCSS = isCSS;
        // Creates new virtual source files for the CSS modules.
        var _createLanguageServiceSourceFile = ts.createLanguageServiceSourceFile;
        ts.createLanguageServiceSourceFile = function (fileName, scriptSnapshot) {
            var rest = [];
            for (var _i = 2; _i < arguments.length; _i++) {
                rest[_i - 2] = arguments[_i];
            }
            if (isCSS(fileName)) {
                scriptSnapshot = cssSnapshots_1.getDtsSnapshot(ts, scriptSnapshot, options);
            }
            var sourceFile = _createLanguageServiceSourceFile.apply(void 0, [fileName,
                scriptSnapshot].concat(rest));
            if (isCSS(fileName)) {
                sourceFile.isDeclarationFile = true;
            }
            return sourceFile;
        };
        // Updates virtual source files as files update.
        var _updateLanguageServiceSourceFile = ts.updateLanguageServiceSourceFile;
        ts.updateLanguageServiceSourceFile = function (sourceFile, scriptSnapshot) {
            var rest = [];
            for (var _i = 2; _i < arguments.length; _i++) {
                rest[_i - 2] = arguments[_i];
            }
            if (isCSS(sourceFile.fileName)) {
                scriptSnapshot = cssSnapshots_1.getDtsSnapshot(ts, scriptSnapshot, options);
            }
            sourceFile = _updateLanguageServiceSourceFile.apply(void 0, [sourceFile,
                scriptSnapshot].concat(rest));
            if (isCSS(sourceFile.fileName)) {
                sourceFile.isDeclarationFile = true;
            }
            return sourceFile;
        };
        if (info.languageServiceHost.resolveModuleNames) {
            var _resolveModuleNames_1 = info.languageServiceHost.resolveModuleNames.bind(info.languageServiceHost);
            info.languageServiceHost.resolveModuleNames = function (moduleNames, containingFile, reusedNames) {
                var resolvedModules = _resolveModuleNames_1(moduleNames, containingFile, reusedNames);
                return moduleNames.map(function (moduleName, index) {
                    if (isRelativeCSS(moduleName)) {
                        return {
                            extension: ts_module.Extension.Dts,
                            isExternalLibraryImport: false,
                            resolvedFileName: path.resolve(path.dirname(containingFile), moduleName),
                        };
                    }
                    return resolvedModules[index];
                });
            };
        }
        return info.languageService;
    }
    function getExternalFiles(project) {
        return project.getFileNames().filter(_isCSS);
    }
    return { create: create, getExternalFiles: getExternalFiles };
}
module.exports = init;
