"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var icss_utils_1 = require("icss-utils");
var postcss = require("postcss");
var postcssIcssSelectors = require("postcss-icss-selectors");
var postcssNested = require("postcss-nested");
var strip = require("strip-css-singleline-comments/sync");
var classTransforms_1 = require("./classTransforms");
var processor = postcss(postcssNested, postcssIcssSelectors({ mode: 'local' }));
exports.getClasses = function (css) {
    try {
        var cleanCss = strip(css);
        var processedCss = processor.process(cleanCss);
        return icss_utils_1.extractICSS(processedCss.root).icssExports;
    }
    catch (e) {
        return {};
    }
};
var classNameToProperty = function (className) { return "'" + className + "': string;"; };
var flattenClassNames = function (previousValue, currentValue) {
    if (previousValue === void 0) { previousValue = []; }
    return previousValue.concat(currentValue);
};
exports.createExports = function (classes, options) { return "declare const classes: {\n  " + Object.keys(classes)
    .map(classTransforms_1.transformClasses(options.camelCase))
    .reduce(flattenClassNames, [])
    .map(classNameToProperty)
    .join('\n  ') + "\n};\nexport default classes;\n"; };
exports.getDtsSnapshot = function (ts, scriptSnapshot, options) {
    var css = scriptSnapshot.getText(0, scriptSnapshot.getLength());
    var classes = exports.getClasses(css);
    var dts = exports.createExports(classes, options);
    return ts.ScriptSnapshot.fromString(dts);
};
