/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.connector.ssh.connector;

import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSch;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.Logger;
import org.eclipse.tm.internal.terminal.provisional.api.NullSettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.provider.TerminalConnectorImpl;
import org.eclipse.tm.terminal.connector.ssh.connector.ISshSettings;
import org.eclipse.tm.terminal.connector.ssh.connector.SshConnection;
import org.eclipse.tm.terminal.connector.ssh.connector.SshSettings;

public class SshConnector
extends TerminalConnectorImpl {
    private OutputStream fOutputStream;
    private InputStream fInputStream;
    private JSch fJsch;
    private ChannelShell fChannel;
    private SshConnection fConnection;
    private final SshSettings fSettings;
    private int fWidth;
    private int fHeight;

    public SshConnector() {
        this(new SshSettings());
    }

    public SshConnector(SshSettings settings) {
        this.fSettings = settings;
    }

    public void initialize() throws Exception {
        this.fJsch = new JSch();
    }

    public void connect(ITerminalControl control) {
        super.connect(control);
        this.fConnection = new SshConnection(this, control);
        this.fConnection.start();
    }

    public synchronized void doDisconnect() {
        this.fConnection.disconnect();
        if (this.getInputStream() != null) {
            try {
                this.getInputStream().close();
            }
            catch (Exception exception) {
                Logger.logException((Exception)exception);
            }
        }
        if (this.getTerminalToRemoteStream() != null) {
            try {
                this.getTerminalToRemoteStream().close();
            }
            catch (Exception exception) {
                Logger.logException((Exception)exception);
            }
        }
    }

    public void setTerminalSize(int newWidth, int newHeight) {
        if (this.fChannel != null && (newWidth != this.fWidth || newHeight != this.fHeight)) {
            this.fChannel.setPtySize(newWidth, newHeight, 8 * newWidth, 8 * newHeight);
            this.fWidth = newWidth;
            this.fHeight = newHeight;
        }
    }

    public InputStream getInputStream() {
        return this.fInputStream;
    }

    public OutputStream getTerminalToRemoteStream() {
        return this.fOutputStream;
    }

    void setInputStream(InputStream inputStream) {
        this.fInputStream = inputStream;
    }

    void setOutputStream(OutputStream outputStream) {
        this.fOutputStream = outputStream;
    }

    public ISshSettings getSshSettings() {
        return this.fSettings;
    }

    public void setDefaultSettings() {
        this.fSettings.load((ISettingsStore)new NullSettingsStore());
    }

    public String getSettingsSummary() {
        return this.fSettings.getSummary();
    }

    public void load(ISettingsStore store) {
        this.fSettings.load(store);
    }

    public void save(ISettingsStore store) {
        this.fSettings.save(store);
    }

    protected JSch getJsch() {
        return this.fJsch;
    }

    ChannelShell getChannel() {
        return this.fChannel;
    }

    void setChannel(ChannelShell channel) {
        this.fChannel = channel;
        this.fWidth = -1;
        this.fHeight = -1;
    }
}

