/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.binaryproject.internal.sourcelookup;

import java.io.File;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.launching.sourcelookup.advanced.AdvancedSourceLookup;
import org.eclipse.jdt.launching.sourcelookup.advanced.IWorkspaceProjectDescriber;
import org.eclipse.jdt.launching.sourcelookup.containers.PackageFragmentRootSourceContainer;
import org.eclipse.m2e.binaryproject.internal.BinaryProjectPlugin;

public class BinaryProjectDescriber
implements IWorkspaceProjectDescriber {
    static File getBinaryLocation(IProject project) throws CoreException {
        if (!project.isOpen()) {
            return null;
        }
        String binaryLocation = project.getPersistentProperty(BinaryProjectPlugin.QNAME_JAR);
        if (binaryLocation == null) {
            return null;
        }
        return new File(binaryLocation);
    }

    public void describeProject(IJavaProject project, IWorkspaceProjectDescriber.IJavaProjectSourceDescription description) throws CoreException {
        File binaryLocation = BinaryProjectDescriber.getBinaryLocation(project.getProject());
        if (binaryLocation == null) {
            return;
        }
        Map classpath = AdvancedSourceLookup.getClasspath((IJavaProject)project);
        IPackageFragmentRoot binary = (IPackageFragmentRoot)classpath.remove(binaryLocation);
        if (binary == null) {
            return;
        }
        description.addDependencies(classpath);
        description.addLocation(binaryLocation);
        description.addSourceContainerFactory(() -> new PackageFragmentRootSourceContainer(binary));
    }
}

