/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.syntax;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.swt.graphics.Image;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableParametrized;
import org.jkiss.dbeaver.model.sql.SQLDataSource;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.TextUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLCompletionProcessor;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLCompletionProposal;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLSearchUtils;
import org.jkiss.dbeaver.ui.editors.text.parser.SQLIdentifierDetector;
import org.jkiss.dbeaver.ui.editors.text.parser.SQLWordPartDetector;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.utils.CommonUtils;

class SQLCompletionAnalyzer
implements DBRRunnableParametrized<DBRProgressMonitor> {
    private static final Log log = Log.getLog(SQLCompletionAnalyzer.class);
    private static final String MATCH_ANY_PATTERN = "%";
    private final CompletionRequest request;
    private DBRProgressMonitor monitor;

    SQLCompletionAnalyzer(CompletionRequest request) {
        this.request = request;
    }

    public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            this.monitor = monitor;
            this.runAnalyzer();
        }
        catch (DBException e) {
            throw new InvocationTargetException(e);
        }
    }

    private void runAnalyzer() throws DBException {
        boolean emptyWord;
        DBPDataSource dataSource = this.request.editor.getDataSource();
        if (dataSource == null) {
            return;
        }
        boolean bl = emptyWord = this.request.wordPart.length() == 0;
        if (this.request.queryType != null) {
            DBSObject selectedObject;
            DBSObjectContainer sc;
            DBSObject rootObject;
            if (emptyWord) {
                DBSObject leftTable;
                rootObject = null;
                if (this.request.queryType == SQLCompletionProcessor.QueryType.COLUMN && dataSource instanceof DBSObjectContainer) {
                    rootObject = this.getTableFromAlias((DBSObjectContainer)dataSource, null);
                    if (rootObject instanceof DBSEntity && "ON".equals(this.request.wordDetector.getPrevKeyWord()) && this.makeJoinColumnProposals((DBSObjectContainer)dataSource, (DBSEntity)rootObject)) {
                        return;
                    }
                } else if (dataSource instanceof DBSObjectContainer) {
                    DBSObject selectedObject2 = DBUtils.getActiveInstanceObject((DBSInstance)dataSource.getDefaultInstance());
                    if (selectedObject2 != null) {
                        this.makeProposalsFromChildren((DBPObject)selectedObject2, null, false);
                        rootObject = DBUtils.getPublicObject((DBPObject)selectedObject2.getParentObject());
                    } else {
                        rootObject = dataSource;
                    }
                }
                if (rootObject != null) {
                    this.makeProposalsFromChildren((DBPObject)rootObject, null, false);
                }
                if (this.request.queryType == SQLCompletionProcessor.QueryType.JOIN && !this.request.proposals.isEmpty() && dataSource instanceof DBSObjectContainer && (leftTable = this.getTableFromAlias((DBSObjectContainer)dataSource, null)) instanceof DBSEntity) {
                    this.filterNonJoinableProposals((DBSEntity)leftTable);
                }
            } else {
                rootObject = null;
                if (this.request.queryType == SQLCompletionProcessor.QueryType.COLUMN && dataSource instanceof DBSObjectContainer) {
                    int divPos;
                    String tableAlias;
                    sc = (DBSObjectContainer)dataSource;
                    selectedObject = DBUtils.getActiveInstanceObject((DBSInstance)dataSource.getDefaultInstance());
                    if (selectedObject instanceof DBSObjectContainer) {
                        sc = (DBSObjectContainer)selectedObject;
                    }
                    String string = tableAlias = (divPos = this.request.wordPart.indexOf(this.request.editor.getSyntaxManager().getStructSeparator())) == -1 ? null : this.request.wordPart.substring(0, divPos);
                    if (tableAlias == null && !CommonUtils.isEmpty((String)this.request.wordPart) && (rootObject = this.getTableFromAlias(sc, this.request.wordPart)) != null) {
                        this.request.searchFinished = true;
                        return;
                    }
                    rootObject = this.getTableFromAlias(sc, tableAlias);
                }
                if (rootObject != null) {
                    this.makeProposalsFromChildren((DBPObject)rootObject, this.request.wordPart, false);
                } else if (this.request.queryType != SQLCompletionProcessor.QueryType.COLUMN && this.request.queryType != SQLCompletionProcessor.QueryType.EXEC) {
                    this.makeDataSourceProposals();
                }
            }
            if (!this.request.simpleMode && (this.request.queryType == SQLCompletionProcessor.QueryType.EXEC || this.request.queryType == SQLCompletionProcessor.QueryType.COLUMN && dataSource.getContainer().getPreferenceStore().getBoolean("SQLEditor.ContentAssistant.show.column.procedures")) && dataSource instanceof DBSObjectContainer) {
                DBSStructureAssistant structureAssistant = (DBSStructureAssistant)DBUtils.getAdapter(DBSStructureAssistant.class, (Object)dataSource);
                sc = (DBSObjectContainer)dataSource;
                selectedObject = DBUtils.getActiveInstanceObject((DBSInstance)dataSource.getDefaultInstance());
                if (selectedObject instanceof DBSObjectContainer) {
                    sc = (DBSObjectContainer)selectedObject;
                }
                if (structureAssistant != null) {
                    this.makeProposalsFromAssistant(dataSource, structureAssistant, sc, new DBSObjectType[]{RelationalObjectType.TYPE_PROCEDURE}, this.request.wordPart);
                }
            }
        }
        if (!emptyWord) {
            this.makeProposalsFromQueryParts();
        }
    }

    private void makeProposalsFromQueryParts() {
        if (!CommonUtils.isEmpty((String)this.request.activeQuery) && !CommonUtils.isEmpty((String)this.request.wordPart)) {
            if (this.request.wordPart.indexOf(this.request.editor.getSyntaxManager().getStructSeparator()) != -1) {
                return;
            }
            SQLDialect sqlDialect = SQLUtils.getDialectFromDataSource((DBPDataSource)this.request.editor.getDataSource());
            String tableNamePattern = SQLCompletionAnalyzer.getTableNamePattern(sqlDialect);
            String tableAliasPattern = this.getTableAliasPattern("(" + this.request.wordPart + "[a-z]*)", tableNamePattern);
            Pattern rp = Pattern.compile(tableAliasPattern);
            Matcher matcher = rp.matcher(this.request.activeQuery);
            while (matcher.find()) {
                String tableName = matcher.group(1);
                String tableAlias = matcher.group(2);
                if (tableAlias.equals(this.request.wordPart)) continue;
                this.request.proposals.add(0, SQLCompletionAnalyzer.createCompletionProposal(this.request, tableName, tableName, DBPKeywordType.OTHER, null, false, null));
                this.request.proposals.add(0, SQLCompletionAnalyzer.createCompletionProposal(this.request, tableAlias, tableAlias, DBPKeywordType.OTHER, null, false, null));
            }
        }
    }

    private boolean makeJoinColumnProposals(DBSObjectContainer sc, DBSEntity leftTable) {
        SQLWordPartDetector joinTableDetector = new SQLWordPartDetector(this.request.editor.getDocument(), this.request.editor.getSyntaxManager(), this.request.wordDetector.getStartOffset(), 2);
        List prevWords = joinTableDetector.getPrevWords();
        if (!CommonUtils.isEmpty((Collection)prevWords)) {
            DBPDataSource dataSource = this.request.editor.getDataSource();
            SQLDialect sqlDialect = SQLUtils.getDialectFromDataSource((DBPDataSource)dataSource);
            String rightTableName = (String)prevWords.get(0);
            String[] allNames = SQLUtils.splitFullIdentifier((String)rightTableName, (String)sqlDialect.getCatalogSeparator(), (String[][])sqlDialect.getIdentifierQuoteStrings(), (boolean)false);
            DBSObject rightTable = SQLSearchUtils.findObjectByFQN(this.monitor, sc, dataSource, Arrays.asList(allNames), !this.request.simpleMode, (SQLIdentifierDetector)this.request.wordDetector);
            if (rightTable instanceof DBSEntity) {
                try {
                    String joinCriteria = SQLUtils.generateTableJoin((DBRProgressMonitor)this.monitor, (DBSEntity)leftTable, (String)DBUtils.getQuotedIdentifier((DBSObject)leftTable), (DBSEntity)((DBSEntity)rightTable), (String)DBUtils.getQuotedIdentifier((DBSObject)rightTable));
                    this.request.proposals.add(SQLCompletionAnalyzer.createCompletionProposal(this.request, joinCriteria, joinCriteria, DBPKeywordType.OTHER, "Join condition"));
                    return true;
                }
                catch (DBException e) {
                    log.error((Object)"Error generating join condition", (Throwable)e);
                }
            }
        }
        return false;
    }

    private void filterNonJoinableProposals(DBSEntity leftTable) {
        List<SQLCompletionProposal> proposals = this.request.proposals;
        ArrayList<SQLCompletionProposal> joinableProposals = new ArrayList<SQLCompletionProposal>();
        for (SQLCompletionProposal proposal : proposals) {
            DBSEntity rightTable;
            if (!(proposal.getObject() instanceof DBSEntity) || !this.tableHaveJoins(rightTable = (DBSEntity)proposal.getObject(), leftTable) && !this.tableHaveJoins(leftTable, rightTable)) continue;
            proposal.setReplacementAfter(" ON");
            joinableProposals.add(proposal);
        }
        if (!joinableProposals.isEmpty()) {
            this.request.proposals.clear();
            this.request.proposals.addAll(joinableProposals);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean tableHaveJoins(DBSEntity table1, DBSEntity table2) {
        try {
            Collection associations = table1.getAssociations(this.monitor);
            if (!CommonUtils.isEmpty((Collection)associations)) {
                for (DBSEntityAssociation fk : associations) {
                    if (fk.getAssociatedEntity() != table2) continue;
                    return true;
                }
            }
            return false;
        }
        catch (DBException e) {
            log.error((Object)e);
            return false;
        }
    }

    private void makeDataSourceProposals() throws DBException {
        Object sc;
        DBPDataSource dataSource = this.request.editor.getDataSource();
        DBSObjectContainer rootContainer = (DBSObjectContainer)DBUtils.getAdapter(DBSObjectContainer.class, (Object)dataSource);
        if (rootContainer == null) {
            return;
        }
        DBSObjectContainer childObject = sc = rootContainer;
        String[] tokens = this.request.wordDetector.splitWordPart();
        DBSObject[] selectedObjects = DBUtils.getSelectedObjects((DBRProgressMonitor)this.monitor, (DBSObject)dataSource);
        DBSObjectContainer[] selectedContainers = new DBSObjectContainer[selectedObjects.length];
        int i = 0;
        while (i < selectedObjects.length) {
            selectedContainers[i] = (DBSObjectContainer)DBUtils.getAdapter(DBSObjectContainer.class, (Object)selectedObjects[i]);
            ++i;
        }
        String lastToken = null;
        i = 0;
        while (i < tokens.length) {
            String token = tokens[i];
            if (i == tokens.length - 1 && !this.request.wordDetector.getWordPart().endsWith(".")) {
                lastToken = token;
                break;
            }
            if (sc == null) break;
            String objectName = this.request.wordDetector.isQuoted(token) ? this.request.wordDetector.removeQuotes(token) : DBObjectNameCaseTransformer.transformName((DBPDataSource)dataSource, (String)token);
            DBSObject dBSObject = childObject = objectName == null ? null : sc.getChild(this.monitor, objectName);
            if (childObject == null && i == 0 && objectName != null) {
                int k = 0;
                while (k < selectedContainers.length) {
                    if (selectedContainers[k] != null && (childObject = selectedContainers[k].getChild(this.monitor, objectName)) != null) {
                        sc = selectedContainers[k];
                        break;
                    }
                    ++k;
                }
            }
            if (childObject == null) {
                if (i == 0) {
                    List references;
                    DBSStructureAssistant structureAssistant;
                    childObject = this.getTableFromAlias((DBSObjectContainer)sc, token);
                    if (childObject == null && !this.request.simpleMode && (structureAssistant = (DBSStructureAssistant)DBUtils.getAdapter(DBSStructureAssistant.class, (Object)sc)) != null && !(references = structureAssistant.findObjectsByMask(this.monitor, null, structureAssistant.getAutoCompleteObjectTypes(), this.request.wordDetector.removeQuotes(token), this.request.wordDetector.isQuoted(token), false, 2)).isEmpty()) {
                        childObject = ((DBSObjectReference)references.iterator().next()).resolveObject(this.monitor);
                    }
                } else {
                    return;
                }
            }
            sc = childObject instanceof DBSObjectContainer ? childObject : null;
            ++i;
        }
        if (childObject == null) {
            return;
        }
        if (lastToken == null) {
            this.makeProposalsFromChildren((DBPObject)childObject, null, false);
        } else {
            this.makeProposalsFromChildren((DBPObject)childObject, lastToken, false);
            int cfr_ignored_0 = tokens.length;
            if (tokens.length == 1) {
                int k = 0;
                while (k < selectedContainers.length) {
                    if (selectedContainers[k] != null && selectedContainers[k] != childObject) {
                        this.makeProposalsFromChildren((DBPObject)selectedContainers[k], lastToken, true);
                    }
                    ++k;
                }
                if (this.request.proposals.isEmpty() && !this.request.simpleMode) {
                    DBSStructureAssistant structureAssistant = null;
                    DBSObjectContainer object = childObject;
                    while (object != null) {
                        structureAssistant = (DBSStructureAssistant)DBUtils.getAdapter(DBSStructureAssistant.class, (Object)object);
                        if (structureAssistant != null) break;
                        object = object.getParentObject();
                    }
                    if (structureAssistant != null) {
                        this.makeProposalsFromAssistant(dataSource, structureAssistant, (DBSObjectContainer)sc, null, lastToken);
                    }
                }
            }
        }
    }

    @Nullable
    private DBSObject getTableFromAlias(DBSObjectContainer sc, @Nullable String token) {
        Pattern aliasPattern;
        String structNamePattern;
        SQLScriptElement queryAtPos;
        DBPDataSource dataSource;
        if (token == null) {
            token = "";
        }
        if (!((dataSource = this.request.editor.getDataSource()) instanceof SQLDataSource)) {
            return null;
        }
        if (this.request.activeQuery == null && (queryAtPos = this.request.editor.extractQueryAtPos(this.request.documentOffset)) != null) {
            this.request.activeQuery = queryAtPos.getText();
        }
        if (this.request.activeQuery == null) {
            return null;
        }
        ArrayList<String> nameList = new ArrayList<String>();
        SQLDialect sqlDialect = SQLUtils.getDialectFromDataSource((DBPDataSource)dataSource);
        String catalogSeparator = sqlDialect.getCatalogSeparator();
        while (token.endsWith(catalogSeparator)) {
            token = token.substring(0, token.length() - 1);
        }
        String tableNamePattern = SQLCompletionAnalyzer.getTableNamePattern(sqlDialect);
        if (CommonUtils.isEmpty((String)token)) {
            String kwList = "from|update|join|into";
            if (this.request.queryType != SQLCompletionProcessor.QueryType.COLUMN) {
                kwList = String.valueOf(kwList) + "|,";
            }
            structNamePattern = "(?:" + kwList + ")\\s+" + tableNamePattern;
        } else {
            structNamePattern = this.getTableAliasPattern(token, tableNamePattern);
        }
        try {
            aliasPattern = Pattern.compile(structNamePattern, 2);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return null;
        }
        String testQuery = SQLUtils.stripComments((SQLDialect)this.request.editor.getSyntaxManager().getDialect(), (String)this.request.activeQuery);
        Matcher matcher = aliasPattern.matcher(testQuery);
        if (matcher.find()) {
            int groupCount = matcher.groupCount();
            int i = 1;
            while (i <= groupCount) {
                String group = matcher.group(i);
                if (!CommonUtils.isEmpty((String)group)) {
                    String[][] quoteStrings = sqlDialect.getIdentifierQuoteStrings();
                    String[] allNames = SQLUtils.splitFullIdentifier((String)group, (String)catalogSeparator, (String[][])quoteStrings, (boolean)false);
                    Collections.addAll(nameList, allNames);
                }
                ++i;
            }
        }
        return SQLSearchUtils.findObjectByFQN(this.monitor, sc, dataSource, nameList, true, (SQLIdentifierDetector)this.request.wordDetector);
    }

    private String getTableAliasPattern(String alias, String tableNamePattern) {
        return String.valueOf(tableNamePattern) + "\\s+(?:as\\s)?" + alias + "[\\s,]+";
    }

    private static String getTableNamePattern(SQLDialect sqlDialect) {
        String[][] quoteStrings = sqlDialect.getIdentifierQuoteStrings();
        StringBuilder quotes = new StringBuilder();
        if (quoteStrings != null) {
            String[][] stringArray = quoteStrings;
            int n = quoteStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String[] quotePair = stringArray[n2];
                if (quotes.indexOf(quotePair[0]) == -1) {
                    quotes.append('\\').append(quotePair[0]);
                }
                if (quotes.indexOf(quotePair[1]) == -1) {
                    quotes.append('\\').append(quotePair[1]);
                }
                ++n2;
            }
        }
        return "([\\p{L}0-9_$\u00a7#@\\.\\-" + quotes.toString() + "]+)";
    }

    private void makeProposalsFromChildren(DBPObject parent, @Nullable String startPart, boolean addFirst) throws DBException {
        DBPDataSource dataSource;
        int divPos;
        if (this.request.queryType == SQLCompletionProcessor.QueryType.EXEC) {
            return;
        }
        if (startPart != null && (divPos = (startPart = this.request.wordDetector.removeQuotes(startPart).toUpperCase(Locale.ENGLISH)).lastIndexOf(this.request.editor.getSyntaxManager().getStructSeparator())) != -1) {
            startPart = startPart.substring(divPos + 1);
        }
        if ((dataSource = this.request.editor.getDataSource()) != null) {
            dataSource.getContainer().getPreferenceStore().getBoolean("SQLEditor.ContentAssistant.matching.fuzzy");
        }
        Collection children = null;
        if (parent instanceof DBSObjectContainer) {
            children = ((DBSObjectContainer)parent).getChildren(this.monitor);
        } else if (parent instanceof DBSEntity) {
            children = ((DBSEntity)parent).getAttributes(this.monitor);
        }
        if (children != null && !children.isEmpty()) {
            String prevWord;
            ArrayList<DBSObject> matchedObjects = new ArrayList<DBSObject>();
            HashMap<String, Integer> scoredMatches = new HashMap<String, Integer>();
            boolean simpleMode = this.request.simpleMode;
            boolean allObjects = !simpleMode && "*".equals(startPart);
            String objPrefix = null;
            if (allObjects && !CommonUtils.isEmpty((Collection)this.request.wordDetector.getPrevWords()) && (prevWord = (String)this.request.wordDetector.getPrevWords().get(0)).length() > 0 && prevWord.charAt(prevWord.length() - 1) == this.request.editor.getSyntaxManager().getStructSeparator()) {
                objPrefix = prevWord;
            }
            StringBuilder combinedMatch = new StringBuilder();
            for (DBSObject child : children) {
                int score;
                if (DBUtils.isHiddenObject((Object)child)) continue;
                if (allObjects) {
                    if (combinedMatch.length() > 0) {
                        combinedMatch.append(", ");
                        if (objPrefix != null) {
                            combinedMatch.append(objPrefix);
                        }
                    }
                    combinedMatch.append(DBUtils.getQuotedIdentifier((DBSObject)child));
                    continue;
                }
                if (dataSource != null && !dataSource.getContainer().getPreferenceStore().getBoolean("SQLEditor.ContentAssistant.matching.fuzzy")) {
                    if (!CommonUtils.isEmpty((String)startPart) && !CommonUtils.startsWithIgnoreCase((String)child.getName(), (String)startPart)) continue;
                    matchedObjects.add(child);
                    continue;
                }
                int n = score = CommonUtils.isEmpty((String)startPart) ? 1 : TextUtils.fuzzyScore((CharSequence)child.getName(), (CharSequence)startPart);
                if (score <= 0) continue;
                matchedObjects.add(child);
                scoredMatches.put(child.getName(), score);
            }
            if (combinedMatch.length() > 0) {
                String replaceString = combinedMatch.toString();
                this.request.proposals.add(SQLCompletionAnalyzer.createCompletionProposal(this.request, replaceString, replaceString, DBPKeywordType.OTHER, "All objects"));
            } else if (!matchedObjects.isEmpty()) {
                if (startPart == null || scoredMatches.isEmpty()) {
                    if (dataSource != null && dataSource.getContainer().getPreferenceStore().getBoolean("SQLEditor.ContentAssistant.proposals.sort.alphabetically")) {
                        matchedObjects.sort(DBUtils.nameComparatorIgnoreCase());
                    }
                } else {
                    matchedObjects.sort((o1, o2) -> {
                        int score2;
                        int score1 = (Integer)scoredMatches.get(o1.getName());
                        if (score1 == (score2 = ((Integer)scoredMatches.get(o2.getName())).intValue())) {
                            if (o1 instanceof DBSAttributeBase) {
                                return ((DBSAttributeBase)o1).getOrdinalPosition() - ((DBSAttributeBase)o2).getOrdinalPosition();
                            }
                            return o1.getName().compareToIgnoreCase(o2.getName());
                        }
                        return score2 - score1;
                    });
                }
                ArrayList<SQLCompletionProposal> childProposals = new ArrayList<SQLCompletionProposal>(matchedObjects.size());
                for (DBSObject child : matchedObjects) {
                    SQLCompletionProposal proposal = this.makeProposalsFromObject(child, !(parent instanceof DBPDataSource));
                    if (!scoredMatches.isEmpty()) {
                        int proposalScore = (Integer)scoredMatches.get(child.getName());
                        proposal.setProposalScore(proposalScore);
                    }
                    childProposals.add(proposal);
                }
                if (addFirst) {
                    this.request.proposals.addAll(0, childProposals);
                } else {
                    this.request.proposals.addAll(childProposals);
                }
            }
        }
    }

    private boolean objectNameMatches(@Nullable String startPart, DBSObject child, boolean matchContains) {
        String nameCI = child.getName().toUpperCase(Locale.ENGLISH);
        return matchContains ? nameCI.contains(startPart) : nameCI.startsWith(startPart);
    }

    private void makeProposalsFromAssistant(DBPDataSource dataSource, DBSStructureAssistant assistant, @Nullable DBSObjectContainer rootSC, DBSObjectType[] objectTypes, String objectName) throws DBException {
        List references = assistant.findObjectsByMask(this.monitor, (DBSObject)rootSC, objectTypes == null ? assistant.getAutoCompleteObjectTypes() : objectTypes, this.makeObjectNameMask(dataSource, this.request.wordDetector.removeQuotes(objectName)), this.request.wordDetector.isQuoted(objectName), dataSource.getContainer().getPreferenceStore().getBoolean("SQLEditor.ContentAssistant.use.global.search"), 100);
        for (DBSObjectReference reference : references) {
            this.request.proposals.add(this.makeProposalsFromObject((DBPNamedObject)reference, !(rootSC instanceof DBPDataSource), reference.getObjectType().getImage()));
        }
    }

    private String makeObjectNameMask(DBPDataSource dataSource, String objectName) {
        if (dataSource.getContainer().getPreferenceStore().getBoolean("SQLEditor.ContentAssistant.matching.fuzzy")) {
            return MATCH_ANY_PATTERN + objectName + MATCH_ANY_PATTERN;
        }
        return String.valueOf(objectName) + MATCH_ANY_PATTERN;
    }

    private SQLCompletionProposal makeProposalsFromObject(DBSObject object, boolean useShortName) {
        DBPImage objectIcon;
        DBNDatabaseNode node = NavigatorUtils.getNodeByObject((DBRProgressMonitor)this.monitor, (DBSObject)object, (boolean)false);
        DBPImage dBPImage = objectIcon = node == null ? null : node.getNodeIconDefault();
        if (objectIcon == null) {
            objectIcon = DBValueFormatting.getObjectImage((DBPObject)object);
        }
        return this.makeProposalsFromObject((DBPNamedObject)object, useShortName, objectIcon);
    }

    private SQLCompletionProposal makeProposalsFromObject(DBPNamedObject object, boolean useShortName, @Nullable DBPImage objectIcon) {
        String objectName = useShortName ? object.getName() : DBUtils.getObjectFullName((DBPNamedObject)object, (DBPEvaluationContext)DBPEvaluationContext.DML);
        boolean isSingleObject = true;
        String replaceString = null;
        DBPDataSource dataSource = this.request.editor.getDataSource();
        if (dataSource != null) {
            DBSObject selectedObject;
            DBSObjectReference structObject;
            DBPPreferenceStore prefs = this.request.editor.getActivePreferenceStore();
            if (!prefs.getBoolean("SQLEditor.ContentAssistant.proposals.short.name") && object instanceof DBSObjectReference && this.request.wordDetector.getFullWord().indexOf(this.request.editor.getSyntaxManager().getStructSeparator()) == -1 && (structObject = (DBSObjectReference)object).getContainer() != null && (selectedObject = DBUtils.getActiveInstanceObject((DBSInstance)dataSource.getDefaultInstance())) != structObject.getContainer()) {
                replaceString = structObject.getFullyQualifiedName(DBPEvaluationContext.DML);
                isSingleObject = false;
            }
            if (replaceString == null) {
                replaceString = prefs.getBoolean("SQLEditor.ContentAssistant.proposals.long.name") && object instanceof DBPQualifiedObject ? ((DBPQualifiedObject)object).getFullyQualifiedName(DBPEvaluationContext.DML) : DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)object.getName());
            }
        } else {
            replaceString = DBUtils.getObjectShortName((Object)object);
        }
        return SQLCompletionAnalyzer.createCompletionProposal(this.request, replaceString, objectName, DBPKeywordType.OTHER, objectIcon, isSingleObject, object);
    }

    static SQLCompletionProposal createCompletionProposal(CompletionRequest request, String replaceString, String displayString, DBPKeywordType proposalType, @Nullable DBPImage image, boolean isObject, @Nullable DBPNamedObject object) {
        boolean quotedString;
        SQLEditorBase editor = request.editor;
        DBPPreferenceStore store = editor.getActivePreferenceStore();
        DBPDataSource dataSource = editor.getDataSource();
        if (dataSource != null) {
            // empty if block
        }
        if (!(quotedString = request.wordDetector.isQuoted(replaceString))) {
            int proposalCase = store.getInt("SQLEditor.ContentAssistant.insert.case");
            switch (proposalCase) {
                case 1: {
                    replaceString = replaceString.toUpperCase();
                    break;
                }
                case 2: {
                    replaceString = replaceString.toLowerCase();
                    break;
                }
                default: {
                    if (isObject) break;
                    SQLDialect dialect = editor.getSyntaxManager().getDialect();
                    DBPKeywordType keywordType = dialect.getKeywordType(replaceString);
                    replaceString = keywordType == DBPKeywordType.KEYWORD ? editor.getSyntaxManager().getKeywordCase().transform(replaceString) : dialect.storesUnquotedCase().transform(replaceString);
                }
            }
        }
        Image img = image == null ? null : DBeaverIcons.getImage((DBPImage)image);
        return new SQLCompletionProposal(request, displayString, replaceString, replaceString.length(), img, null, proposalType, null, object);
    }

    protected static SQLCompletionProposal createCompletionProposal(CompletionRequest request, String replaceString, String displayString, DBPKeywordType proposalType, String description) {
        return new SQLCompletionProposal(request, displayString, replaceString, replaceString.length(), null, null, proposalType, description, null);
    }

    static class CompletionRequest {
        final SQLEditorBase editor;
        final boolean simpleMode;
        int documentOffset;
        String activeQuery = null;
        SQLWordPartDetector wordDetector;
        String wordPart;
        SQLCompletionProcessor.QueryType queryType;
        final List<SQLCompletionProposal> proposals = new ArrayList<SQLCompletionProposal>();
        boolean searchFinished = false;

        CompletionRequest(SQLEditorBase editor, int documentOffset, boolean simpleMode) {
            this.editor = editor;
            this.documentOffset = documentOffset;
            this.simpleMode = simpleMode;
        }
    }
}

